/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.properties;

import java.util.Map;
import java.util.function.Predicate;
import tech.jhipster.lite.common.domain.JHipsterCollections;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.properties.InvalidPropertyTypeException;
import tech.jhipster.lite.module.domain.properties.UnknownPropertyException;

record JHipsterModuleParameters(Map<String, Object> parameters) {
    public JHipsterModuleParameters(Map<String, Object> parameters) {
        this.parameters = JHipsterCollections.immutable(parameters);
    }

    <T> T getOrDefault(String key, T defaultValue, Class<T> clazz) {
        return (T)this.getOrDefault(key, defaultValue, clazz, t -> false);
    }

    <T> T getOrDefault(String key, T defaultValue, Class<T> clazz, Predicate<T> isEmpty) {
        Assert.notBlank("key", key);
        if (!this.parameters.containsKey(key)) {
            return defaultValue;
        }
        T value = this.get(key, clazz);
        if (isEmpty.test(value)) {
            return defaultValue;
        }
        return value;
    }

    <T> T get(String key, Class<T> clazz) {
        Assert.notBlank("key", key);
        Object property = this.parameters.get(key);
        if (property == null) {
            throw new UnknownPropertyException(key);
        }
        if (clazz.isInstance(property)) {
            return clazz.cast(property);
        }
        throw InvalidPropertyTypeException.builder().key(key).expectedType(clazz).actualType(property.getClass());
    }

    public Map<String, Object> get() {
        return this.parameters();
    }
}

