/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.properties;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import tech.jhipster.lite.module.domain.properties.InvalidProjectBaseNameException;

public record JHipsterProjectBaseName(String name) {
    private static final Pattern NAME_PATTERN = Pattern.compile("^[a-zA-Z0-9]+$");
    private static final String DEFAULT_NAME = "jhipster";
    public static final JHipsterProjectBaseName DEFAULT = new JHipsterProjectBaseName("jhipster");

    public JHipsterProjectBaseName(String name) {
        this.name = this.buildName(name);
    }

    private String buildName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return DEFAULT_NAME;
        }
        this.assertValidName(name);
        return name;
    }

    private void assertValidName(String name) {
        if (!NAME_PATTERN.matcher(name).matches()) {
            throw new InvalidProjectBaseNameException();
        }
    }

    public String get() {
        return this.name();
    }

    public String uncapitalized() {
        return StringUtils.uncapitalize((String)this.name());
    }

    public String capitalized() {
        return StringUtils.capitalize((String)this.name());
    }

    public String kebabCase() {
        return StringUtils.uncapitalize((String)this.name()).replaceAll("([A-Z])", "-$1").toLowerCase();
    }
}

