/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.replacement;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.JHipsterProjectFilePath;
import tech.jhipster.lite.module.domain.replacement.ContentReplacer;
import tech.jhipster.lite.module.domain.replacement.ElementReplacer;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleReplacements;

public class JHipsterModuleOptionalReplacements
extends JHipsterModuleReplacements {
    private JHipsterModuleOptionalReplacements(JHipsterModuleOptionalReplacementsBuilder builder) {
        super(builder);
    }

    public static JHipsterModuleOptionalReplacementsBuilder builder(JHipsterModule.JHipsterModuleBuilder module) {
        return new JHipsterModuleOptionalReplacementsBuilder(module);
    }

    public static class JHipsterModuleOptionalReplacementsBuilder
    extends JHipsterModuleReplacements.JHipsterModuleReplacementsBuilder<JHipsterModuleOptionalReplacements, JHipsterModuleFileOptionalReplacementsBuilder> {
        private JHipsterModuleOptionalReplacementsBuilder(JHipsterModule.JHipsterModuleBuilder module) {
            super(module);
        }

        @Override
        public JHipsterModuleFileOptionalReplacementsBuilder in(JHipsterProjectFilePath file) {
            return new JHipsterModuleFileOptionalReplacementsBuilder(this, file);
        }

        @Override
        public JHipsterModuleOptionalReplacements build() {
            return new JHipsterModuleOptionalReplacements(this);
        }
    }

    private record OptionalReplacer(ElementReplacer replacer, String updatedValue) {
        public OptionalReplacer {
            Assert.notNull("replacer", replacer);
            Assert.notNull("updatedValue", updatedValue);
        }

        public String apply(String content) {
            if (this.replacer.dontNeedReplacement(content, this.updatedValue())) {
                return content;
            }
            return this.replacer().replacement().apply(content, this.updatedValue());
        }
    }

    private record OptionalFileReplacer(JHipsterProjectFilePath file, OptionalReplacer replacement) implements ContentReplacer
    {
        private static final Logger log = LoggerFactory.getLogger(OptionalFileReplacer.class);

        public OptionalFileReplacer {
            Assert.notNull("file", file);
            Assert.notNull("replacement", replacement);
        }

        @Override
        public String apply(String content) {
            return this.replacement().apply(content);
        }

        @Override
        public void handleError(Throwable e) {
            log.debug("Can't apply optional replacement: {}", (Object)e.getMessage());
        }
    }

    public static class JHipsterModuleFileOptionalReplacementsBuilder
    extends JHipsterModuleReplacements.JHipsterModuleFileReplacementsBuilder<JHipsterModuleOptionalReplacementsBuilder, JHipsterModuleFileOptionalReplacementsBuilder> {
        private JHipsterModuleFileOptionalReplacementsBuilder(JHipsterModuleOptionalReplacementsBuilder replacements, JHipsterProjectFilePath file) {
            super(replacements, file);
        }

        @Override
        protected ContentReplacer buildReplacer(JHipsterProjectFilePath file, ElementReplacer toReplace, String replacement) {
            return new OptionalFileReplacer(file, new OptionalReplacer(toReplace, replacement));
        }
    }
}

