/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.replacement;

import java.util.function.BiFunction;
import java.util.regex.Pattern;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.replacement.ElementReplacer;
import tech.jhipster.lite.module.domain.replacement.ReplacementCondition;

public record RegexNeedleBeforeReplacer(ReplacementCondition condition, Pattern pattern) implements ElementReplacer
{
    public RegexNeedleBeforeReplacer {
        Assert.notNull("condition", condition);
        Assert.notNull("pattern", pattern);
    }

    @Override
    public boolean notMatchIn(String content) {
        return !this.linePattern().matcher(content).find();
    }

    @Override
    public BiFunction<String, String, String> replacement() {
        return (content, replacement) -> this.linePattern().matcher((CharSequence)content).replaceAll(result -> replacement + "\n" + result.group());
    }

    private Pattern linePattern() {
        String stringPattern = this.searchMatcher();
        if (this.isLinePattern(stringPattern)) {
            return this.pattern();
        }
        return Pattern.compile("^.*" + stringPattern, this.pattern().flags());
    }

    private boolean isLinePattern(String stringPattern) {
        return stringPattern.startsWith("^");
    }

    @Override
    public String searchMatcher() {
        return this.pattern().pattern();
    }
}

