/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.resource;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.JHipsterModuleSlug;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.resource.DuplicatedSlugException;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.module.domain.resource.UnknownSlugException;

public class JHipsterModulesResources {
    private final Map<JHipsterModuleSlug, JHipsterModuleResource> resources;

    public JHipsterModulesResources(Collection<JHipsterModuleResource> modulesResources) {
        Assert.field("modulesResources", modulesResources).notEmpty().noNullElement();
        this.assertUniqueSlugs(modulesResources);
        this.resources = Collections.unmodifiableMap(modulesResources.stream().collect(Collectors.toMap(JHipsterModuleResource::slug, Function.identity(), (x, y) -> y, LinkedHashMap::new)));
    }

    private void assertUniqueSlugs(Collection<JHipsterModuleResource> modulesResources) {
        if (this.duplicatedSlug(modulesResources)) {
            throw new DuplicatedSlugException();
        }
    }

    private boolean duplicatedSlug(Collection<JHipsterModuleResource> modulesResources) {
        return modulesResources.stream().map(JHipsterModuleResource::slug).collect(Collectors.toSet()).size() != modulesResources.size();
    }

    public Stream<JHipsterModuleResource> stream() {
        return this.resources.values().stream();
    }

    public JHipsterModuleResource get(JHipsterModuleSlug slug) {
        this.assertKnownSlug(slug);
        return this.resources.get(slug);
    }

    public JHipsterModule build(JHipsterModuleSlug slug, JHipsterModuleProperties properties) {
        Assert.notNull("slug", slug);
        Assert.notNull("properties", properties);
        return this.get(slug).factory().create(properties);
    }

    private void assertKnownSlug(JHipsterModuleSlug slug) {
        Assert.notNull("slug", slug);
        if (!this.resources.containsKey(slug)) {
            throw new UnknownSlugException(slug);
        }
    }
}

