/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary.git;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.git.GitCommitMessage;
import tech.jhipster.lite.module.domain.git.GitRepository;
import tech.jhipster.lite.module.domain.properties.JHipsterProjectFolder;
import tech.jhipster.lite.module.infrastructure.secondary.git.GitCommitException;
import tech.jhipster.lite.module.infrastructure.secondary.git.GitInitException;

@Repository
class JGitGitRepository
implements GitRepository {
    private static final Logger log = LoggerFactory.getLogger(JGitGitRepository.class);

    JGitGitRepository() {
    }

    @Override
    public void init(JHipsterProjectFolder folder) {
        Assert.notNull("folder", folder);
        if (this.isGit(folder)) {
            log.debug("Folder {} is already a git project, not running init", (Object)folder.get());
            return;
        }
        try {
            Git.init().setInitialBranch("main").setDirectory(this.folderFile(folder)).call();
        }
        catch (IllegalStateException | GitAPIException | JGitInternalException e) {
            throw new GitInitException("Error during git init: " + e.getMessage(), e);
        }
    }

    private boolean isGit(JHipsterProjectFolder folder) {
        return Files.exists(Paths.get(folder.get(), new String[0]).resolve(".git"), new LinkOption[0]);
    }

    @Override
    public void commitAll(JHipsterProjectFolder folder, GitCommitMessage message) {
        Assert.notNull("folder", folder);
        Assert.notNull("message", message);
        File folderFile = this.folderFile(folder);
        try (Git gitFolder = Git.open((File)folderFile);){
            gitFolder.add().addFilepattern(".").call();
            gitFolder.commit().setSign(Boolean.valueOf(false)).setMessage(message.get()).call();
        }
        catch (IOException | GitAPIException | JGitInternalException e) {
            throw new GitCommitException("Can't commit :" + e.getMessage(), e);
        }
    }

    private File folderFile(JHipsterProjectFolder folder) {
        return new File(folder.get());
    }
}

