/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.project.infrastructure.secondary;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Map;
import tech.jhipster.lite.project.domain.history.ProjectAction;

class PersistedProjectAction {
    private final String module;
    private final Instant date;
    private final Map<String, Object> properties;

    private PersistedProjectAction(@JsonProperty(value="module") String module, @JsonProperty(value="date") Instant date, @JsonProperty(value="properties") Map<String, Object> properties) {
        this.module = module;
        this.date = date;
        this.properties = properties;
    }

    static PersistedProjectAction from(ProjectAction action) {
        return new PersistedProjectAction(action.module().get(), action.date(), action.parameters().get());
    }

    ProjectAction toDomain() {
        return ProjectAction.builder().module(this.getModule()).date(this.getDate()).parameters(this.getProperties());
    }

    public String getModule() {
        return this.module;
    }

    public Instant getDate() {
        return this.date;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

