/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.sonarqube.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javabuildplugin.JavaBuildPlugin;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class SonarQubeModulesFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/sonar");
    private static final JHipsterDestination SONAR_PROPERTIES_DESTINATION = JHipsterModule.to("sonar-project.properties");
    private final DockerImages dockerImages;

    public SonarQubeModulesFactory(DockerImages dockerImages) {
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildBackendModule(JHipsterModuleProperties properties) {
        return this.commonModuleFiles(properties).files().add(SOURCE.template("sonar-project.properties"), SONAR_PROPERTIES_DESTINATION).and().build();
    }

    public JHipsterModule buildBackendFrontendModule(JHipsterModuleProperties properties) {
        return this.commonModuleFiles(properties).files().add(SOURCE.template("sonar-fullstack-project.properties"), SONAR_PROPERTIES_DESTINATION).and().build();
    }

    private JHipsterModule.JHipsterModuleBuilder commonModuleFiles(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).context().put("sonarqubeDockerImage", this.dockerImages.get("sonarqube").fullName()).and().documentation(JHipsterModule.documentationTitle("sonar"), SOURCE.template("sonar.md")).startupCommand("docker compose -f src/main/docker/sonar.yml up -d\n./mvnw clean verify sonar:sonar").javaBuildPlugins().plugin(this.propertiesPlugin()).pluginManagement(this.sonarPlugin()).and().files().add(SOURCE.template("sonar.yml"), JHipsterModule.toSrcMainDocker().append("sonar.yml")).and();
    }

    private JavaBuildPlugin propertiesPlugin() {
        return JavaBuildPlugin.builder().groupId("org.codehaus.mojo").artifactId("properties-maven-plugin").versionSlug("properties-maven-plugin").additionalElements(" <executions>\n  <execution>\n    <phase>initialize</phase>\n    <goals>\n      <goal>read-project-properties</goal>\n    </goals>\n    <configuration>\n      <files>\n        <file>sonar-project.properties</file>\n      </files>\n    </configuration>\n  </execution>\n</executions>\n").build();
    }

    private JavaBuildPlugin sonarPlugin() {
        return JavaBuildPlugin.builder().groupId("org.sonarsource.scanner.maven").artifactId("sonar-maven-plugin").versionSlug("sonar-maven-plugin").build();
    }
}

