/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.postgresql.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.generator.server.springboot.database.common.domain.DatabaseType;
import tech.jhipster.lite.generator.server.springboot.database.sqlcommon.domain.SQLCommonModuleBuilder;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.docker.DockerImageVersion;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class PostgresqlModuleFactory {
    public static final String ORG_POSTGRESQL = "org.postgresql";
    private final DockerImages dockerImages;

    public PostgresqlModuleFactory(DockerImages dockerImages) {
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        DockerImageVersion dockerImage = this.dockerImages.get("postgres");
        return SQLCommonModuleBuilder.sqlCommonModuleBuilder(properties, DatabaseType.POSTGRESQL, dockerImage, JHipsterModule.documentationTitle("Postgresql"), JHipsterModule.artifactId("postgresql")).javaDependencies().addDependency(JavaDependency.builder().groupId(JHipsterModule.groupId(ORG_POSTGRESQL)).artifactId(JHipsterModule.artifactId("postgresql")).scope(JavaDependencyScope.RUNTIME).build()).and().springMainProperties().set(JHipsterModule.propertyKey("spring.datasource.url"), JHipsterModule.propertyValue("jdbc:postgresql://localhost:5432/" + properties.projectBaseName().name())).set(JHipsterModule.propertyKey("spring.datasource.username"), JHipsterModule.propertyValue(properties.projectBaseName().name())).set(JHipsterModule.propertyKey("spring.datasource.driver-class-name"), JHipsterModule.propertyValue("org.postgresql.Driver")).and().springTestProperties().set(JHipsterModule.propertyKey("spring.datasource.url"), JHipsterModule.propertyValue("jdbc:tc:postgresql:" + dockerImage.version().get() + ":///" + properties.projectBaseName().name() + "?TC_TMPFS=/testtmpfs:rw")).and().springMainLogger(ORG_POSTGRESQL, LogLevel.WARN).springTestLogger(ORG_POSTGRESQL, LogLevel.WARN).springTestLogger("org.jboss.logging", LogLevel.WARN).build();
    }
}

