/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.dbmigration.flyway.domain;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class FlywayModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/dbmigration/flyway/resources");
    private static final DateTimeFormatter FILE_DATE_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss").withZone(ZoneOffset.UTC);
    private static final GroupId FLYWAY_GROUP_ID = JHipsterModule.groupId("org.flywaydb");

    public JHipsterModule buildInitializationModule(JHipsterModuleProperties properties, Instant date) {
        Assert.notNull("properties", properties);
        Assert.notNull("date", date);
        return JHipsterModule.moduleBuilder(properties).javaDependencies().addDependency(FLYWAY_GROUP_ID, JHipsterModule.artifactId("flyway-core")).and().files().add(SOURCE.file("V00000000000000__init.sql"), JHipsterModule.to("src/main/resources/db/migration").append(this.initFilename(date))).and().springMainProperties().set(JHipsterModule.propertyKey("spring.flyway.enabled"), JHipsterModule.propertyValue("true")).set(JHipsterModule.propertyKey("spring.flyway.locations"), JHipsterModule.propertyValue("classpath:db/migration")).and().build();
    }

    private String initFilename(Instant date) {
        return "V" + FILE_DATE_FORMAT.format(date) + "__init.sql";
    }

    public JHipsterModule buildMysqlDependencyModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).javaDependencies().addDependency(FLYWAY_GROUP_ID, JHipsterModule.artifactId("flyway-mysql")).and().build();
    }
}

