/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.docker.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javabuildplugin.JavaBuildPlugin;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class SpringBootDockerModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/docker");
    private static final JHipsterSource JIB_SOURCE = SOURCE.append("jib");

    public JHipsterModule buildJibModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).context().put("mainClass", this.mainClassName(properties)).and().javaBuildPlugins().plugin(this.jibPlugin(properties)).and().files().add(JIB_SOURCE.template("entrypoint.sh"), JHipsterModule.to("src/main/docker/jib").append("entrypoint.sh")).and().build();
    }

    private String mainClassName(JHipsterModuleProperties properties) {
        return properties.basePackage().get() + "." + properties.projectBaseName().capitalized() + "App";
    }

    private JavaBuildPlugin jibPlugin(JHipsterModuleProperties properties) {
        return JHipsterModule.javaBuildPlugin().groupId("com.google.cloud.tools").artifactId("jib-maven-plugin").versionSlug("jib-maven-plugin").additionalElements(this.jibPluginAdditionalElements(properties)).build();
    }

    private String jibPluginAdditionalElements(JHipsterModuleProperties properties) {
        return "<configuration>\n  <from>\n    <image>eclipse-temurin:17-jre-focal</image>\n    <platforms>\n      <platform>\n        <architecture>amd64</architecture>\n        <os>linux</os>\n      </platform>\n    </platforms>\n  </from>\n  <to>\n    <image>%s:latest</image>\n  </to>\n  <container>\n    <entrypoint>\n      <shell>bash</shell>\n      <option>-c</option>\n      <arg>/entrypoint.sh</arg>\n    </entrypoint>\n    <ports>\n      <port>%s</port>\n    </ports>\n    <environment>\n      <SPRING_OUTPUT_ANSI_ENABLED>ALWAYS</SPRING_OUTPUT_ANSI_ENABLED>\n      <JHIPSTER_SLEEP>0</JHIPSTER_SLEEP>\n    </environment>\n    <creationTime>USE_CURRENT_TIMESTAMP</creationTime>\n    <user>1000</user>\n  </container>\n  <extraDirectories>\n    <paths>src/main/docker/jib</paths>\n    <permissions>\n      <permission>\n        <file>/entrypoint.sh</file>\n        <mode>755</mode>\n      </permission>\n    </permissions>\n  </extraDirectories>\n</configuration>\n".formatted(properties.projectBaseName().get(), properties.serverPort().get());
    }

    public JHipsterModule buildDockerFileModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return JHipsterModule.moduleBuilder(properties).files().add(SOURCE.template("Dockerfile"), JHipsterModule.to("Dockerfile")).and().build();
    }
}

