/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.javaproperties;

import java.util.Map;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.javaproperties.Comment;
import tech.jhipster.lite.module.domain.javaproperties.PropertyKey;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;
import tech.jhipster.lite.module.domain.javaproperties.SpringProfile;
import tech.jhipster.lite.module.domain.javaproperties.SpringPropertyType;
import tech.jhipster.lite.module.domain.javaproperties.SpringPropertyTypeFileName;

public class SpringPropertiesBlockComment
implements SpringPropertyTypeFileName {
    private final SpringPropertyType type;
    private final Comment comment;
    private final Map<PropertyKey, PropertyValue> properties;
    private final SpringProfile profile;

    public SpringPropertiesBlockComment(SpringPropertiesBlockCommentBuilder builder) {
        Assert.notNull("comment", builder.comment);
        Assert.notNull("properties", builder.properties);
        this.type = builder.type;
        this.comment = builder.comment;
        this.properties = builder.properties;
        this.profile = this.buildProfile(builder.profile);
    }

    private SpringProfile buildProfile(SpringProfile profile) {
        if (profile == null) {
            return SpringProfile.DEFAULT;
        }
        return profile;
    }

    public static SpringPropertiesBlockCommentBuilder builder(SpringPropertyType type) {
        return new SpringPropertiesBlockCommentBuilder(type);
    }

    @Override
    public SpringPropertyType type() {
        return this.type;
    }

    public Comment comment() {
        return this.comment;
    }

    public Map<PropertyKey, PropertyValue> properties() {
        return this.properties;
    }

    @Override
    public String filename() {
        if (this.profile.isDefault()) {
            return this.type.filePrefix();
        }
        return this.type.filePrefix() + "-" + this.profile.get();
    }

    public static class SpringPropertiesBlockCommentBuilder
    implements SpringPropertiesBlockCommentCommentBuilder,
    SpringPropertiesBlockCommentPropertiesBuilder,
    SpringPropertiesBlockCommentProfileBuilder {
        private final SpringPropertyType type;
        private Comment comment;
        private Map<PropertyKey, PropertyValue> properties;
        private SpringProfile profile;

        private SpringPropertiesBlockCommentBuilder(SpringPropertyType type) {
            Assert.notNull("type", (Object)type);
            this.type = type;
        }

        @Override
        public SpringPropertiesBlockCommentPropertiesBuilder comment(Comment comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public SpringPropertiesBlockCommentProfileBuilder properties(Map<PropertyKey, PropertyValue> properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public SpringPropertiesBlockCommentProfileBuilder profile(SpringProfile profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public SpringPropertiesBlockComment build() {
            return new SpringPropertiesBlockComment(this);
        }
    }

    public static interface SpringPropertiesBlockCommentProfileBuilder {
        public SpringPropertiesBlockCommentProfileBuilder profile(SpringProfile var1);

        public SpringPropertiesBlockComment build();
    }

    public static interface SpringPropertiesBlockCommentPropertiesBuilder {
        public SpringPropertiesBlockCommentProfileBuilder properties(Map<PropertyKey, PropertyValue> var1);
    }

    public static interface SpringPropertiesBlockCommentCommentBuilder {
        public SpringPropertiesBlockCommentPropertiesBuilder comment(Comment var1);
    }
}

