/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.landscape;

import java.util.Collection;
import java.util.stream.Collectors;
import tech.jhipster.lite.error.domain.GeneratorException;
import tech.jhipster.lite.module.domain.JHipsterSlug;
import tech.jhipster.lite.module.domain.landscape.LandscapeErrorKey;

class InvalidLandscapeException
extends GeneratorException {
    private InvalidLandscapeException(GeneratorException.GeneratorExeptionBuilder builder) {
        super(builder);
    }

    static InvalidLandscapeException duplicatedSlug(String slug) {
        return new InvalidLandscapeException(InvalidLandscapeException.internalServerError(LandscapeErrorKey.DUPLICATED_SLUG).message(InvalidLandscapeException.buildDuplicatedSlugMessage(slug)).addParameter("slug", slug));
    }

    private static String buildDuplicatedSlugMessage(String slug) {
        return "Can't share a slug between a feature and a module, slug \"" + slug + "\" is duplicated";
    }

    static InvalidLandscapeException unknownDepdencency(Collection<JHipsterSlug> knownSlugs, Collection<JHipsterSlug> remainingElements) {
        return new InvalidLandscapeException(InvalidLandscapeException.internalServerError(LandscapeErrorKey.UNKNOWN_DEPENDENCY).message(InvalidLandscapeException.buildUnknownDependencyMessage(knownSlugs, remainingElements)));
    }

    private static String buildUnknownDependencyMessage(Collection<JHipsterSlug> knownSlugs, Collection<JHipsterSlug> remainingElements) {
        return "Can't build landscape this happens if you have an unknown dependency or circular dependencies. Known elements: " + InvalidLandscapeException.displayableSlugs(knownSlugs) + " and trying to find element with all known dependencies in: " + InvalidLandscapeException.displayableSlugs(remainingElements);
    }

    private static String displayableSlugs(Collection<JHipsterSlug> slugs) {
        return slugs.stream().map(JHipsterSlug::get).collect(Collectors.joining(", "));
    }

    public static InvalidLandscapeException missingRootElement() {
        return new InvalidLandscapeException(InvalidLandscapeException.internalServerError(LandscapeErrorKey.MISSING_ROOT_ELEMENT).message("Can't build landscape, can't find any root element"));
    }
}

