/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import tech.jhipster.lite.common.domain.Generated;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.error.domain.GeneratorException;
import tech.jhipster.lite.module.domain.javaproperties.Comment;
import tech.jhipster.lite.module.domain.javaproperties.PropertyKey;

class PropertiesFileSpringCommentsHandler {
    private static final String HASH = "#";
    private static final String EQUAL = "=";
    private static final String BLANK_SPACE = " ";
    private final Path file;

    public PropertiesFileSpringCommentsHandler(Path file) {
        Assert.notNull("file", file);
        this.file = file;
    }

    public void set(PropertyKey key, Comment comment) {
        Assert.notNull("key", key);
        Assert.notNull("value", comment);
        this.updateComments(key, comment);
    }

    @Generated
    private void updateComments(PropertyKey key, Comment comment) {
        try {
            String properties = this.buildComments(key, comment);
            if (properties.isEmpty()) {
                return;
            }
            Files.write(this.file, properties.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw GeneratorException.technicalError("Error updating comments: " + e.getMessage(), e);
        }
    }

    private String buildComments(PropertyKey key, Comment comment) throws IOException {
        String currentProperties = this.readProperties();
        int propertyIndex = currentProperties.indexOf(this.propertyId(key));
        if (propertyIndex != -1) {
            currentProperties = this.deletePreviousComment(currentProperties, propertyIndex);
            propertyIndex = currentProperties.indexOf(this.propertyId(key));
            String start = currentProperties.substring(0, propertyIndex);
            String end = currentProperties.substring(propertyIndex);
            return start + this.commentLine(comment) + end;
        }
        return currentProperties;
    }

    private String deletePreviousComment(String currentProperties, int propertyIndex) {
        if (this.isFirstLine(currentProperties, propertyIndex)) {
            return currentProperties;
        }
        CommentPosition commentPosition = this.findPossibleCommentPosition(currentProperties, propertyIndex);
        if (this.propertyHasComment(currentProperties, commentPosition)) {
            return this.deleteComment(currentProperties, commentPosition);
        }
        return currentProperties;
    }

    private boolean isFirstLine(String currentProperties, int propertyIndex) {
        return currentProperties.lastIndexOf("\n", propertyIndex) == -1;
    }

    private CommentPosition findPossibleCommentPosition(String currentProperties, int propertyIndex) {
        int commentLineBreakIndex = currentProperties.lastIndexOf("\n", propertyIndex);
        int commentStartIndex = this.isFirstLine(currentProperties, commentLineBreakIndex - 1) ? 0 : currentProperties.lastIndexOf("\n", commentLineBreakIndex - 1);
        return new CommentPosition(commentStartIndex, ++commentLineBreakIndex);
    }

    private boolean propertyHasComment(String currentProperties, CommentPosition commentPosition) {
        String possiblePreviousComment = currentProperties.substring(commentPosition.start, commentPosition.end);
        return possiblePreviousComment.trim().startsWith(HASH);
    }

    private String deleteComment(String currentProperties, CommentPosition commentPosition) {
        return currentProperties.substring(0, commentPosition.start) + currentProperties.substring(commentPosition.end);
    }

    private String readProperties() throws IOException {
        if (Files.notExists(this.file, new LinkOption[0])) {
            return "";
        }
        return Files.readString(this.file);
    }

    private String commentLine(Comment comment) {
        return HASH + BLANK_SPACE + comment.get() + "\n";
    }

    private String propertyId(PropertyKey key) {
        return key.get() + EQUAL;
    }

    private record CommentPosition(int start, int end) {
    }
}

