/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import tech.jhipster.lite.common.domain.Generated;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.error.domain.GeneratorException;
import tech.jhipster.lite.module.domain.javaproperties.Comment;
import tech.jhipster.lite.module.domain.javaproperties.PropertyKey;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;

public class PropertiesFileSpringPropertiesBlockCommentsHandler {
    private static final String HASH = "#";
    private static final String BLANK_SPACE = " ";
    private final Path file;

    public PropertiesFileSpringPropertiesBlockCommentsHandler(Path file) {
        Assert.notNull("file", file);
        this.file = file;
    }

    public void set(Comment comment, Map<PropertyKey, PropertyValue> properties) {
        Assert.notNull("comment", comment);
        Assert.notNull("properties", properties);
        this.updatePropertiesBlockComments(comment, properties);
    }

    @Generated
    private void updatePropertiesBlockComments(Comment comment, Map<PropertyKey, PropertyValue> properties) {
        try {
            String propertiesBlock = this.buildPropertiesBlockComments(comment, properties);
            if (propertiesBlock.isEmpty()) {
                return;
            }
            Files.write(this.file, propertiesBlock.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw GeneratorException.technicalError("Error updating properties block with comment: " + e.getMessage(), e);
        }
    }

    private String buildPropertiesBlockComments(Comment comment, Map<PropertyKey, PropertyValue> properties) throws IOException {
        String currentProperties = this.readProperties();
        if (currentProperties.isEmpty()) {
            return currentProperties;
        }
        return this.organizePropertiesInBlock(currentProperties, properties, comment);
    }

    private String readProperties() throws IOException {
        if (Files.notExists(this.file, new LinkOption[0])) {
            return "";
        }
        return Files.readString(this.file);
    }

    private String organizePropertiesInBlock(String currentProperties, Map<PropertyKey, PropertyValue> properties, Comment comment) {
        ExtractedProperties extractedProperties = this.extractPropertiesToBlock(currentProperties, properties);
        return extractedProperties.updateProperties + this.buildCommentBlock(comment) + "\n" + extractedProperties.propertiesInBlock;
    }

    private ExtractedProperties extractPropertiesToBlock(String currentProperties, Map<PropertyKey, PropertyValue> properties) {
        String updateProperties = currentProperties;
        StringBuilder propertiesInBlock = new StringBuilder();
        for (PropertyKey propertyKey : properties.keySet()) {
            updateProperties = this.deletePreviousCommentBlock(updateProperties, propertyKey);
            PropertyAndCommentPosition propertyAndCommentPosition = this.findPropertyAndCommentPosition(updateProperties, propertyKey);
            this.organizePropertiesInBlock(propertiesInBlock, this.extractPropertyAndComment(updateProperties, propertyAndCommentPosition));
            updateProperties = this.deleteProperty(updateProperties, propertyAndCommentPosition);
        }
        return new ExtractedProperties(updateProperties, propertiesInBlock.toString());
    }

    private String buildCommentBlock(Comment comment) {
        return HASH + HASH + BLANK_SPACE + comment.get();
    }

    private String deletePreviousCommentBlock(String updateProperties, PropertyKey propertyKey) {
        PropertyPosition propertyPosition = this.findPropertyPosition(updateProperties, propertyKey);
        if (this.isFirstLine(updateProperties, propertyPosition.start)) {
            return updateProperties;
        }
        CommentPosition commentPosition = this.findPossibleCommentPosition(updateProperties, propertyPosition.start);
        if (this.propertyHasCommentBlock(updateProperties, commentPosition)) {
            return this.deleteComment(updateProperties, commentPosition);
        }
        return updateProperties;
    }

    private PropertyPosition findPropertyPosition(String updateProperties, PropertyKey propertyKey) {
        int propertyStartIndex = updateProperties.indexOf(propertyKey.get());
        int propertyLineBreakIndex = this.isLastLine(updateProperties, propertyStartIndex) ? updateProperties.length() : updateProperties.indexOf("\n", propertyStartIndex) + 1;
        return new PropertyPosition(propertyStartIndex, propertyLineBreakIndex);
    }

    private PropertyAndCommentPosition findPropertyAndCommentPosition(String updateProperties, PropertyKey propertyKey) {
        PropertyPosition propertyPosition = this.findPropertyPosition(updateProperties, propertyKey);
        if (this.isFirstLine(updateProperties, propertyPosition.start)) {
            return new PropertyAndCommentPosition(propertyPosition.start, propertyPosition.end);
        }
        CommentPosition commentPosition = this.findPossibleCommentPosition(updateProperties, propertyPosition.start);
        if (this.propertyHasComment(updateProperties, commentPosition)) {
            return new PropertyAndCommentPosition(commentPosition.start, propertyPosition.end);
        }
        return new PropertyAndCommentPosition(propertyPosition.start, propertyPosition.end);
    }

    private boolean propertyHasComment(String updateProperties, CommentPosition commentPosition) {
        String possiblePreviousComment = updateProperties.substring(commentPosition.start, commentPosition.end);
        return possiblePreviousComment.trim().startsWith(HASH);
    }

    private String extractPropertyAndComment(String updateProperties, PropertyAndCommentPosition propertyAndCommentPosition) {
        return updateProperties.substring(propertyAndCommentPosition.start, propertyAndCommentPosition.end);
    }

    private StringBuilder organizePropertiesInBlock(StringBuilder propertiesInBlock, String extractedProperty) {
        if (propertiesInBlock.isEmpty()) {
            propertiesInBlock.append(this.removeLastLineBreak(extractedProperty));
            return propertiesInBlock;
        }
        propertiesInBlock.append("\n");
        propertiesInBlock.append(this.removeLastLineBreak(extractedProperty));
        return propertiesInBlock;
    }

    private String deleteProperty(String updateProperties, PropertyAndCommentPosition propertyAndCommentPosition) {
        return updateProperties.substring(0, propertyAndCommentPosition.start) + updateProperties.substring(propertyAndCommentPosition.end);
    }

    private String removeLastLineBreak(String updateProperties) {
        if (updateProperties.lastIndexOf("\n") + 1 == updateProperties.length()) {
            return updateProperties.substring(0, updateProperties.lastIndexOf("\n"));
        }
        return updateProperties;
    }

    private boolean isLastLine(String updateProperties, int index) {
        return updateProperties.indexOf("\n", index) == -1;
    }

    private boolean isFirstLine(String currentProperties, int propertyIndex) {
        return currentProperties.lastIndexOf("\n", propertyIndex) == -1;
    }

    private CommentPosition findPossibleCommentPosition(String updateProperties, int propertyIndex) {
        int commentLineBreakIndex = updateProperties.lastIndexOf("\n", propertyIndex);
        int commentStartIndex = this.isFirstLine(updateProperties, commentLineBreakIndex - 1) ? 0 : updateProperties.lastIndexOf("\n", commentLineBreakIndex - 1) + 1;
        return new CommentPosition(commentStartIndex, ++commentLineBreakIndex);
    }

    private boolean propertyHasCommentBlock(String updateProperties, CommentPosition commentPosition) {
        String possiblePreviousComment = updateProperties.substring(commentPosition.start, commentPosition.end);
        return possiblePreviousComment.trim().startsWith("##");
    }

    private String deleteComment(String updateProperties, CommentPosition commentPosition) {
        return updateProperties.substring(0, commentPosition.start) + updateProperties.substring(commentPosition.end);
    }

    private record ExtractedProperties(String updateProperties, String propertiesInBlock) {
    }

    private record PropertyAndCommentPosition(int start, int end) {
    }

    private record PropertyPosition(int start, int end) {
    }

    private record CommentPosition(int start, int end) {
    }
}

