/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.project.infrastructure.secondary;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import tech.jhipster.lite.common.domain.ExcludeFromGeneratedCodeCoverage;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.project.domain.ProjectPath;
import tech.jhipster.lite.project.domain.download.Project;
import tech.jhipster.lite.project.domain.download.ProjectName;
import tech.jhipster.lite.project.infrastructure.secondary.ProjectZippingException;

class FileSystemProjectDownloader {
    private static final Pattern PROJECT_NAME_PATTERN = Pattern.compile("\"description\": *\"([^\"]+)\"");

    FileSystemProjectDownloader() {
    }

    public Optional<Project> download(ProjectPath path) {
        Assert.notNull("path", path);
        Path source = Paths.get(path.get(), new String[0]);
        if (this.notAProject(source)) {
            return Optional.empty();
        }
        return FileSystemProjectDownloader.zip(source).map(content -> {
            ProjectName projectName = this.readProjectName(source);
            return Optional.of(new Project(projectName, (byte[])content));
        }).orElse(Optional.empty());
    }

    private boolean notAProject(Path source) {
        return Files.notExists(source, new LinkOption[0]) || !Files.isDirectory(source, new LinkOption[0]);
    }

    @ExcludeFromGeneratedCodeCoverage(reason="Hard to test exception handling")
    private ProjectName readProjectName(Path source) {
        Path packageJsonPath = source.resolve("package.json");
        if (Files.notExists(packageJsonPath, new LinkOption[0])) {
            return ProjectName.DEFAULT;
        }
        try {
            Matcher matcher = PROJECT_NAME_PATTERN.matcher(Files.readString(packageJsonPath));
            if (!matcher.find()) {
                return ProjectName.DEFAULT;
            }
            return new ProjectName(matcher.group(1));
        }
        catch (IOException e) {
            throw new ProjectZippingException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @ExcludeFromGeneratedCodeCoverage(reason="Hard to test exception handling")
    private static Optional<byte[]> zip(Path source) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try (Stream<Path> sourceFiles = Files.walk(source, new FileVisitOption[0]);
             ZipOutputStream zip = new ZipOutputStream(result);){
            List<Path> files = sourceFiles.filter(FileSystemProjectDownloader.regularFiles()).filter(FileSystemProjectDownloader.notNodeModules()).toList();
            if (files.isEmpty()) {
                Optional<byte[]> optional = Optional.empty();
                return optional;
            }
            files.forEach(FileSystemProjectDownloader.appendFileEntry(source, zip));
            return Optional.of(result.toByteArray());
        }
        catch (IOException e) {
            throw new ProjectZippingException(e);
        }
    }

    private static Predicate<Path> regularFiles() {
        return x$0 -> Files.isRegularFile(x$0, new LinkOption[0]);
    }

    private static Predicate<Path> notNodeModules() {
        return path -> !path.toString().contains("/node_modules/");
    }

    private static Consumer<Path> appendFileEntry(Path source, ZipOutputStream zip) {
        return path -> {
            ZipEntry zipEntry = new ZipEntry(source.relativize((Path)path).toString());
            FileSystemProjectDownloader.appendToZipEntry(zip, path, zipEntry);
        };
    }

    @ExcludeFromGeneratedCodeCoverage(reason="Hard to test exception handling")
    private static void appendToZipEntry(ZipOutputStream zip, Path path, ZipEntry zipEntry) {
        try {
            zip.putNextEntry(zipEntry);
            Files.copy(path, zip);
            zip.closeEntry();
        }
        catch (IOException e) {
            throw new ProjectZippingException(e);
        }
    }
}

