/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.project.infrastructure.secondary;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.jhipster.lite.common.domain.ExcludeFromGeneratedCodeCoverage;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.project.domain.ProjectPath;
import tech.jhipster.lite.project.infrastructure.secondary.ProjectFormatter;
import tech.jhipster.lite.project.infrastructure.secondary.ProjectFormattingException;

@ExcludeFromGeneratedCodeCoverage(reason="Error cases are hard to test and not worth the efforts")
record NpmProjectFormatter(String command) implements ProjectFormatter
{
    private static final Logger log = LoggerFactory.getLogger(NpmProjectFormatter.class);

    public NpmProjectFormatter {
        Assert.notBlank("command", command);
    }

    @Override
    public void format(ProjectPath path) {
        this.execute(path, this.command, "i");
        this.execute(path, this.command, "run", "prettier:format");
    }

    private void execute(ProjectPath path, String ... commands) {
        try {
            Process process = new ProcessBuilder(commands).directory(this.folderFile(path)).start();
            if (this.failedExecution(process)) {
                throw new ProjectFormattingException("Error during formatting, process failed");
            }
            this.traceProcess(Stream.of(commands).collect(Collectors.joining(" ")), process);
        }
        catch (IOException e) {
            throw new ProjectFormattingException("Error during formatting: " + e.getMessage(), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ProjectFormattingException("Error during formatting: " + e.getMessage(), e);
        }
    }

    private File folderFile(ProjectPath path) {
        return new File(path.get());
    }

    private boolean failedExecution(Process process) throws InterruptedException {
        return !process.waitFor(1L, TimeUnit.MINUTES);
    }

    private void traceProcess(String command, Process process) throws IOException {
        String errors;
        if (log.isTraceEnabled()) {
            log.trace("{}: {}", (Object)command, (Object)this.read(process.getInputStream()));
        }
        if (log.isErrorEnabled() && StringUtils.isNotBlank((CharSequence)(errors = this.read(process.getErrorStream())))) {
            log.error("Error during {}: {}", (Object)command, (Object)errors);
        }
    }

    private String read(InputStream stream) throws IOException {
        return new String(stream.readAllBytes(), StandardCharsets.UTF_8).intern();
    }
}

