/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.statistic.infrastructure.secondary;

import java.time.Instant;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;
import tech.jhipster.lite.common.domain.Generated;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.statistic.domain.AppliedModule;

@Document(collection="applied_module")
class AppliedModuleDocument {
    @Id
    @Field(name="id")
    private UUID id;
    @Field(name="path")
    private String path;
    @Field(name="module_slug")
    private String moduleSlug;
    @Field(name="date")
    private Instant date;
    @Field(name="properties")
    private Map<String, Object> properties;

    AppliedModuleDocument() {
    }

    static AppliedModuleDocument from(AppliedModule appliedModule) {
        Assert.notNull("appliedModule", appliedModule);
        return new AppliedModuleDocument().id(appliedModule.id().get()).path(appliedModule.path().get()).moduleSlug(appliedModule.module().slug()).date(appliedModule.date()).properties(appliedModule.properties().get());
    }

    private AppliedModuleDocument id(UUID id) {
        this.id = id;
        return this;
    }

    private AppliedModuleDocument path(String path) {
        this.path = path;
        return this;
    }

    private AppliedModuleDocument moduleSlug(String moduleSlug) {
        this.moduleSlug = moduleSlug;
        return this;
    }

    private AppliedModuleDocument date(Instant date) {
        this.date = date;
        return this;
    }

    private AppliedModuleDocument properties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }

    AppliedModule toDomain() {
        return AppliedModule.builder().id(this.id).path(this.path).module(this.moduleSlug).date(this.date).properties(this.properties);
    }

    @Generated
    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.id).hashCode();
    }

    @Generated
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AppliedModuleDocument other = (AppliedModuleDocument)obj;
        return new EqualsBuilder().append((Object)this.id, (Object)other.id).isEquals();
    }
}

