/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.error.infrastructure.primary;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import tech.jhipster.lite.error.domain.AssertionErrorType;
import tech.jhipster.lite.error.domain.AssertionException;
import tech.jhipster.lite.error.infrastructure.primary.ArgumentsReplacer;

@ControllerAdvice
@Order(value=2147482647)
class AssertionErrorsHandler {
    private static final Logger log = LoggerFactory.getLogger(AssertionErrorsHandler.class);
    private static final String MESSAGES_PREFIX = "assertion-error.";
    private final MessageSource messages;

    public AssertionErrorsHandler(@Qualifier(value="assertionErrorMessageSource") MessageSource messages) {
        Locale.setDefault(Locale.ENGLISH);
        this.messages = messages;
    }

    @ExceptionHandler(value={AssertionException.class})
    ProblemDetail handleAssertionError(AssertionException exception) {
        HttpStatus status = this.buildStatus(exception);
        ProblemDetail problem = ProblemDetail.forStatusAndDetail((HttpStatusCode)status, (String)this.buildDetail(exception));
        problem.setTitle(this.getMessage(exception.type(), "title"));
        problem.setProperty("key", (Object)exception.type().name());
        this.logException(exception, status);
        return problem;
    }

    private HttpStatus buildStatus(AssertionException exception) {
        return Stream.of(exception.getStackTrace()).map(StackTraceElement::getClassName).filter(this.inApplication()).filter(this.notInErrorDomain()).findFirst().filter(this.primaryClass()).map(className -> HttpStatus.BAD_REQUEST).orElse(HttpStatus.INTERNAL_SERVER_ERROR);
    }

    private Predicate<String> inApplication() {
        return className -> className.startsWith("tech.jhipster.lite.");
    }

    private Predicate<String> notInErrorDomain() {
        return className -> !className.startsWith("tech.jhipster.lite.error.domain");
    }

    private Predicate<String> primaryClass() {
        return className -> className.contains(".primary.");
    }

    private String buildDetail(AssertionException exception) {
        String messageTemplate = this.getMessage(exception.type(), "detail");
        return ArgumentsReplacer.replaceParameters(messageTemplate, this.parameters(exception));
    }

    private Map<String, String> parameters(AssertionException exception) {
        HashMap<String, String> parameters = new HashMap<String, String>(exception.parameters());
        parameters.put("field", exception.field());
        return parameters;
    }

    private String getMessage(AssertionErrorType type, String suffix) {
        return this.messages.getMessage(MESSAGES_PREFIX + type.name() + "." + suffix, null, this.locale());
    }

    private Locale locale() {
        return LocaleContextHolder.getLocale();
    }

    private void logException(AssertionException exception, HttpStatus status) {
        if (status.is4xxClientError()) {
            log.info(exception.getMessage(), (Throwable)exception);
        } else {
            log.error(exception.getMessage(), (Throwable)exception);
        }
    }
}

