/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.dbmigration.cassandra.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class CassandraMigrationModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/dbmigration/cassandra");
    private static final String DOCKER_COMPOSE_COMMAND = "docker compose -f src/main/docker/cassandra-migration.yml up -d";
    private static final String CASSANDRA = "cassandra";
    private final DockerImages dockerImages;

    public CassandraMigrationModuleFactory(DockerImages dockerImages) {
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        String packageName = properties.basePackage().get() + ".";
        return JHipsterModule.moduleBuilder(properties).javaDependencies().addDependency(this.cassandraUnitDependency()).and().context().put("cassandraDockerImage", this.dockerImages.get(CASSANDRA).fullName()).and().documentation(JHipsterModule.documentationTitle("Cassandra Migration"), SOURCE.file("cassandra-migration.md")).startupCommand(DOCKER_COMPOSE_COMMAND).files().add(SOURCE.template("TestCassandraMigrationLoader.java"), JHipsterModule.toSrcTestJava().append(packagePath).append("TestCassandraMigrationLoader.java")).add(SOURCE.template("Cassandra-Migration.Dockerfile"), JHipsterModule.toSrcMainDocker().append(CASSANDRA).append("Cassandra-Migration.Dockerfile")).add(SOURCE.file("cassandra-migration.yml"), JHipsterModule.toSrcMainDocker().append("cassandra-migration.yml")).add(SOURCE.file("create-migration-keyspace.cql"), this.toSrcMainResourcesCql().append("create-migration-keyspace.cql")).add(SOURCE.file("README.md"), this.toSrcMainResourcesCql().append("changelog").append("README.md")).batch(SOURCE, this.toSrcMainDockerScripts()).addFile("autoMigrate.sh").addFile("execute-cql.sh").and().and().springTestFactories().append(JHipsterModule.propertyKey("org.springframework.context.ApplicationListener"), JHipsterModule.propertyValue(packageName + "TestCassandraMigrationLoader")).and().build();
    }

    private JavaDependency cassandraUnitDependency() {
        return JHipsterModule.javaDependency().groupId("org.cassandraunit").artifactId("cassandra-unit").versionSlug("cassandraunit").scope(JavaDependencyScope.TEST).build();
    }

    private JHipsterDestination toSrcMainResourcesCql() {
        return JHipsterModule.toSrcMainResources().append("config").append("cql");
    }

    private JHipsterDestination toSrcMainDockerScripts() {
        return JHipsterModule.toSrcMainDocker().append(CASSANDRA).append("scripts");
    }
}

