/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.mvc.security.kipe.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class KipeAuthorizationModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/mvc/security/kipe/authorization");
    private static final JHipsterSource MAIN_SOURCE = SOURCE.append("main");
    private static final JHipsterSource TEST_SOURCE = SOURCE.append("test");
    private static final String APPLICATION = "application";

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String baseName = properties.projectBaseName().capitalized();
        JHipsterDestination mainDestination = JHipsterModule.toSrcMainJava().append(properties.packagePath()).append("kipe");
        JHipsterDestination testDestination = JHipsterModule.toSrcTestJava().append(properties.packagePath()).append("kipe");
        return JHipsterModule.moduleBuilder(properties).context().put("baseName", baseName).and().documentation(JHipsterModule.documentationTitle("Kipe authorization"), SOURCE.template("kipe-authorization.md")).files().add(MAIN_SOURCE.template("package-info.java"), mainDestination.append("package-info.java")).add(MAIN_SOURCE.template("ApplicationAuthorizations.java"), mainDestination.append(APPLICATION).append(baseName + "Authorizations.java")).batch(MAIN_SOURCE, mainDestination.append("domain")).addTemplate("Accesses.java").addTemplate("Action.java").addTemplate("Resource.java").addTemplate("RolesAccesses.java").and().add(TEST_SOURCE.template("ApplicationAuthorizationsTest.java"), testDestination.append(APPLICATION).append(baseName + "AuthorizationsTest.java")).add(TEST_SOURCE.template("TestAuthentications.java"), testDestination.append(APPLICATION).append("TestAuthentications.java")).batch(TEST_SOURCE, testDestination.append("domain")).addTemplate("RolesAccessesFixture.java").addTemplate("RolesAccessesTest.java").addTemplate("ActionTest.java").and().and().build();
    }
}

