/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.mvc.security.oauth2.core.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.generator.server.springboot.mvc.security.common.domain.AuthenticationModulesFactory;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.docker.DockerImageVersion;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacements;
import tech.jhipster.lite.module.domain.replacement.TextNeedleBeforeReplacer;

public class OAuth2ModuleFactory {
    private static final TextNeedleBeforeReplacer IMPORT_NEEDLE = JHipsterModule.lineBeforeText("import org.springframework.boot.test.context.SpringBootTest;");
    private static final GroupId SPRING_GROUP = JHipsterModule.groupId("org.springframework.boot");
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/mvc/security/oauth2/core");
    private static final JHipsterSource MAIN_SOURCE = SOURCE.append("main");
    private static final JHipsterSource TEST_SOURCE = SOURCE.append("test");
    private static final JHipsterSource DOCKER_SOURCE = SOURCE.append("docker");
    private static final JHipsterDestination DOCKER_DESTINATION = JHipsterModule.to("src/main/docker");
    private static final String APPLICATION = "application";
    private static final String PRIMARY = "infrastructure/primary";
    private static final PropertyValue CLIENT_ID = JHipsterModule.propertyValue("web_app");
    private static final PropertyValue CLIENT_SECRET = JHipsterModule.propertyValue("web_app");
    private final DockerImages dockerImages;

    public OAuth2ModuleFactory(DockerImages dockerImages) {
        Assert.notNull("dockerImages", dockerImages);
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        JHipsterModule.JHipsterModuleBuilder builder = AuthenticationModulesFactory.authenticationModuleBuilder(properties);
        this.appendKeycloak(builder);
        this.appendJavaFiles(builder, properties);
        this.appendDependencies(builder);
        this.appendSpringProperties(builder);
        this.appendIntegrationTestAnnotationUpdates(builder, properties);
        return builder.build();
    }

    private void appendKeycloak(JHipsterModule.JHipsterModuleBuilder builder) {
        DockerImageVersion keycloakImage = this.dockerImages.get("quay.io/keycloak/keycloak");
        builder.context().put("dockerKeycloakVersion", keycloakImage.version().get()).put("dockerKeycloakImage", keycloakImage.fullName());
        builder.files().add(DOCKER_SOURCE.template("keycloak.yml"), DOCKER_DESTINATION.append("keycloak.yml")).batch(DOCKER_SOURCE, DOCKER_DESTINATION.append("keycloak-realm-config")).addTemplate("jhipster-realm.json");
    }

    private void appendJavaFiles(JHipsterModule.JHipsterModuleBuilder builder, JHipsterModuleProperties properties) {
        String packagePath = properties.basePackage().path();
        JHipsterDestination mainDestination = JHipsterModule.toSrcMainJava().append(packagePath).append("authentication");
        JHipsterDestination testDestination = JHipsterModule.toSrcTestJava().append(packagePath).append("authentication");
        builder.startupCommand("docker compose -f src/main/docker/keycloak.yml up -d").files().add(MAIN_SOURCE.append(APPLICATION).template("AuthenticatedUser.java"), mainDestination.append(APPLICATION).append("AuthenticatedUser.java")).batch(MAIN_SOURCE.append(PRIMARY), mainDestination.append(PRIMARY)).addTemplate("ApplicationSecurityProperties.java").addTemplate("AudienceValidator.java").addTemplate("Claims.java").addTemplate("CustomClaimConverter.java").addTemplate("JwtGrantedAuthorityConverter.java").addTemplate("OAuth2Configuration.java").addTemplate("SecurityConfiguration.java").and().add(TEST_SOURCE.append(APPLICATION).template("AuthenticatedUserTest.java"), testDestination.append(APPLICATION).append("AuthenticatedUserTest.java")).batch(TEST_SOURCE.append(PRIMARY), testDestination.append(PRIMARY)).addTemplate("ApplicationSecurityPropertiesTest.java").addTemplate("AudienceValidatorTest.java").addTemplate("ClaimsTest.java").addTemplate("CustomClaimConverterTest.java").addTemplate("FakeRequestAttributes.java").addTemplate("JwtGrantedAuthorityConverterTest.java").addTemplate("SecurityConfigurationIT.java").addTemplate("TestSecurityConfiguration.java").addTemplate("WithUnauthenticatedMockUser.java");
    }

    private void appendDependencies(JHipsterModule.JHipsterModuleBuilder builder) {
        builder.javaDependencies().addDependency(SPRING_GROUP, JHipsterModule.artifactId("spring-boot-starter-oauth2-client")).addDependency(SPRING_GROUP, JHipsterModule.artifactId("spring-boot-starter-oauth2-resource-server"));
    }

    private void appendSpringProperties(JHipsterModule.JHipsterModuleBuilder builder) {
        builder.springMainProperties().set(JHipsterModule.propertyKey("spring.security.oauth2.client.provider.oidc.issuer-uri"), JHipsterModule.propertyValue("http://localhost:9080/realms/jhipster")).set(JHipsterModule.propertyKey("spring.security.oauth2.client.registration.oidc.client-id"), CLIENT_ID).set(JHipsterModule.propertyKey("spring.security.oauth2.client.registration.oidc.client-secret"), CLIENT_SECRET).set(JHipsterModule.propertyKey("spring.security.oauth2.client.registration.oidc.scope"), JHipsterModule.propertyValue("openid,profile,email")).set(JHipsterModule.propertyKey("application.security.oauth2.audience"), JHipsterModule.propertyValue("account,api://default"));
        builder.springTestProperties().set(JHipsterModule.propertyKey("spring.main.allow-bean-definition-overriding"), JHipsterModule.propertyValue("true")).set(JHipsterModule.propertyKey("spring.security.oauth2.client.registration.oidc.client-id"), CLIENT_ID).set(JHipsterModule.propertyKey("spring.security.oauth2.client.provider.oidc.issuer-uri"), JHipsterModule.propertyValue("http://DO_NOT_CALL:9080/realms/jhipster"));
    }

    private void appendIntegrationTestAnnotationUpdates(JHipsterModule.JHipsterModuleBuilder builder, JHipsterModuleProperties properties) {
        String baseClass = properties.projectBaseName().capitalized() + "App.class";
        ((JHipsterModuleMandatoryReplacements.JHipsterModuleFileMandatoryReplacementsBuilder)builder.mandatoryReplacements().in(JHipsterModule.path("src/test/java").append(properties.packagePath()).append("IntegrationTest.java")).add(IMPORT_NEEDLE, this.testSecurityConfigurationImport(properties))).add(JHipsterModule.text(baseClass), baseClass + ", TestSecurityConfiguration.class");
    }

    private String testSecurityConfigurationImport(JHipsterModuleProperties properties) {
        return "import " + properties.basePackage().get() + ".authentication.infrastructure.primary.TestSecurityConfiguration;";
    }
}

