/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.technicaltools.gitinfo.domain;

import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javabuildplugin.JavaBuildPlugin;
import tech.jhipster.lite.module.domain.javaproperties.Comment;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class GitInfoModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/technicaltools/gitinfo");
    private static final JHipsterSource MAIN_SOURCE = SOURCE.append("main");
    private static final String GIT_INFO_PRIMARY = "gitinfo/infrastructure/primary";

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        return JHipsterModule.moduleBuilder(properties).files().add(MAIN_SOURCE.template("GitInfoConfiguration.java"), JHipsterModule.toSrcMainJava().append(packagePath).append(GIT_INFO_PRIMARY).append("GitInfoConfiguration.java")).and().springMainProperties().comment(JHipsterModule.propertyKey("management.info.git.mode"), new Comment("Git Information")).set(JHipsterModule.propertyKey("management.info.git.mode"), JHipsterModule.propertyValue("full")).set(JHipsterModule.propertyKey("management.info.git.enabled"), JHipsterModule.propertyValue("true")).set(JHipsterModule.propertyKey("management.info.env.enabled"), JHipsterModule.propertyValue("true")).and().javaBuildPlugins().plugin(this.gitCommitIdPlugin()).pluginManagement(this.gitCommitIdPluginManagement()).and().build();
    }

    private JavaBuildPlugin gitCommitIdPluginManagement() {
        return JavaBuildPlugin.builder().groupId("io.github.git-commit-id").artifactId("git-commit-id-maven-plugin").versionSlug("git-commit-id-plugin").additionalElements("<executions>\n  <execution>\n    <goals>\n      <goal>revision</goal>\n    </goals>\n  </execution>\n</executions>\n<configuration>\n  <failOnNoGitDirectory>false</failOnNoGitDirectory>\n  <failOnUnableToExtractRepoInfo>false</failOnUnableToExtractRepoInfo>\n  <generateGitPropertiesFile>true</generateGitPropertiesFile>\n  <includeOnlyProperties>\n    <includeOnlyProperty>^git.commit.id.abbrev$</includeOnlyProperty>\n    <includeOnlyProperty>^git.commit.id.describe$</includeOnlyProperty>\n    <includeOnlyProperty>^git.branch$</includeOnlyProperty>\n  </includeOnlyProperties>\n  <verbose>false</verbose>\n</configuration>\n").build();
    }

    private JavaBuildPlugin gitCommitIdPlugin() {
        return JavaBuildPlugin.builder().groupId("io.github.git-commit-id").artifactId("git-commit-id-maven-plugin").build();
    }
}

