/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.jhipster.lite.common.domain.JHipsterCollections;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class JHipsterModuleContext {
    private static final Logger log = LoggerFactory.getLogger(JHipsterModuleContext.class);
    private final Map<String, Object> context;
    private final Indentation indentation;

    private JHipsterModuleContext(JHipsterModuleContextBuilder builder) {
        this.context = JHipsterCollections.immutable(builder.context);
        this.indentation = this.loadIndentation();
    }

    private Indentation loadIndentation() {
        Object contextIndentation = this.context.get("indentSize");
        if (contextIndentation instanceof Integer) {
            Integer integerIndentation = (Integer)contextIndentation;
            return Indentation.from(integerIndentation);
        }
        log.info("Context contains an invalid indentation, using default");
        return Indentation.DEFAULT;
    }

    static JHipsterModuleContextBuilder builder(JHipsterModule.JHipsterModuleBuilder module) {
        return new JHipsterModuleContextBuilder(module);
    }

    public Map<String, Object> get() {
        return this.context;
    }

    public Indentation indentation() {
        return this.indentation;
    }

    public static class JHipsterModuleContextBuilder {
        private final JHipsterModule.JHipsterModuleBuilder module;
        private final Map<String, Object> context;

        private JHipsterModuleContextBuilder(JHipsterModule.JHipsterModuleBuilder module) {
            Assert.notNull("module", module);
            this.module = module;
            this.context = this.initialContext(module.properties());
        }

        private Map<String, Object> initialContext(JHipsterModuleProperties properties) {
            HashMap<String, Object> init = new HashMap<String, Object>();
            init.put("baseName", properties.projectBaseName().get());
            init.put("projectName", properties.projectName().get());
            init.put("packageName", properties.basePackage().get());
            init.put("serverPort", properties.serverPort().get());
            init.put("indentSize", properties.indentation().spacesCount());
            return init;
        }

        public JHipsterModuleContextBuilder put(String key, Object value) {
            Assert.notBlank("key", key);
            Assert.notNull("value", value);
            this.context.put(key, value);
            return this;
        }

        public JHipsterModuleContext build() {
            return new JHipsterModuleContext(this);
        }

        public JHipsterModule.JHipsterModuleBuilder and() {
            return this.module;
        }
    }
}

