/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.resource;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.JHipsterModuleSlug;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.resource.DuplicatedSlugException;
import tech.jhipster.lite.module.domain.resource.JHipsterHiddenModules;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleTag;
import tech.jhipster.lite.module.domain.resource.UnknownSlugException;

public class JHipsterModulesResources {
    private static final Logger log = LoggerFactory.getLogger(JHipsterModulesResources.class);
    private final Map<JHipsterModuleSlug, JHipsterModuleResource> resources;

    public JHipsterModulesResources(Collection<JHipsterModuleResource> modulesResources, JHipsterHiddenModules hiddenModules) {
        Assert.field("modulesResources", modulesResources).notEmpty().noNullElement();
        Assert.notNull("jhipsterHiddenModules", hiddenModules);
        this.assertUniqueSlugs(modulesResources);
        this.resources = Collections.unmodifiableMap(this.removeHiddenModules(modulesResources, hiddenModules).collect(Collectors.toMap(JHipsterModuleResource::slug, Function.identity(), (x, y) -> y, LinkedHashMap::new)));
    }

    private Stream<JHipsterModuleResource> removeHiddenModules(Collection<JHipsterModuleResource> modulesResources, JHipsterHiddenModules hiddenModules) {
        Collection<String> nestedDependenciesSlugs = this.findNestedDependencies(modulesResources, hiddenModules);
        DisplayHiddenResources displayHiddenResources = this.findDisplayAndHiddenResources(modulesResources, hiddenModules, nestedDependenciesSlugs);
        if (displayHiddenResources.hasHiddenResources()) {
            String hiddenModulesSlugs = displayHiddenResources.hiddenSlugs();
            log.info("The following modules are hidden: {}.", (Object)hiddenModulesSlugs);
        }
        return displayHiddenResources.displayedStream();
    }

    private DisplayHiddenResources findDisplayAndHiddenResources(Collection<JHipsterModuleResource> modulesResources, JHipsterHiddenModules hiddenModules, Collection<String> nestedDependenciesSlugs) {
        Map<Boolean, List<JHipsterModuleResource>> partitionedResources = modulesResources.stream().collect(Collectors.partitioningBy(resource -> this.allowed((JHipsterModuleResource)resource, hiddenModules, nestedDependenciesSlugs)));
        return new DisplayHiddenResources((Collection<JHipsterModuleResource>)partitionedResources.get(true), (Collection<JHipsterModuleResource>)partitionedResources.get(false));
    }

    private boolean allowed(JHipsterModuleResource resource, JHipsterHiddenModules hiddenModules, Collection<String> nestedDependenciesSlugs) {
        return this.notExcludedSlug(resource, hiddenModules, nestedDependenciesSlugs) && this.noExcludedTag(resource, hiddenModules);
    }

    private boolean notExcludedSlug(JHipsterModuleResource resource, JHipsterHiddenModules hiddenModules, Collection<String> nestedDependenciesSlugs) {
        return !hiddenModules.slugs().contains(resource.slug().get()) && !nestedDependenciesSlugs.contains(resource.slug().get());
    }

    private boolean noExcludedTag(JHipsterModuleResource resource, JHipsterHiddenModules hiddenModules) {
        return hiddenModules.tags().stream().noneMatch(tag -> resource.tags().contains((JHipsterModuleTag)tag));
    }

    private Collection<String> findNestedDependencies(Collection<JHipsterModuleResource> modulesResources, JHipsterHiddenModules hiddenModules) {
        return this.findNestedDependenciesBySlugs(hiddenModules.slugs(), modulesResources);
    }

    private Collection<String> findNestedDependenciesBySlugs(Collection<String> slugs, Collection<JHipsterModuleResource> modulesResources) {
        return slugs.stream().flatMap(slug -> this.allSlugsNestedDependenciesOf((String)slug, modulesResources)).toList();
    }

    private Stream<String> allSlugsNestedDependenciesOf(String slug, Collection<JHipsterModuleResource> modulesResources) {
        return this.allResourcesNestedDependenciesOf(new JHipsterModuleSlug(slug), modulesResources).map(moduleResource -> moduleResource.slug().get());
    }

    private Stream<JHipsterModuleResource> allResourcesNestedDependenciesOf(JHipsterModuleSlug slug, Collection<JHipsterModuleResource> modulesResources) {
        Collection<JHipsterModuleResource> childrensDependencies = this.getChildrensDependencies(slug, modulesResources);
        if (this.noMoreNestedResource(childrensDependencies)) {
            return Stream.of(new JHipsterModuleResource[0]);
        }
        return Stream.concat(childrensDependencies.stream(), childrensDependencies.stream().map(this.moveToNextNestedResource(modulesResources)).flatMap(t -> t));
    }

    private boolean noMoreNestedResource(Collection<JHipsterModuleResource> childrensDependencies) {
        return childrensDependencies.isEmpty();
    }

    private Function<JHipsterModuleResource, Stream<JHipsterModuleResource>> moveToNextNestedResource(Collection<JHipsterModuleResource> modulesResources) {
        return resource -> this.allResourcesNestedDependenciesOf(resource.slug(), modulesResources);
    }

    private Collection<JHipsterModuleResource> getChildrensDependencies(JHipsterModuleSlug slug, Collection<JHipsterModuleResource> modulesResources) {
        return modulesResources.stream().filter(moduleResource -> this.isChildrensOf(slug, (JHipsterModuleResource)moduleResource)).toList();
    }

    private boolean isChildrensOf(JHipsterModuleSlug slug, JHipsterModuleResource moduleResource) {
        return moduleResource.organization().dependencies().stream().anyMatch(dependency -> dependency.slug().equals(slug));
    }

    private void assertUniqueSlugs(Collection<JHipsterModuleResource> modulesResources) {
        if (this.duplicatedSlug(modulesResources)) {
            throw new DuplicatedSlugException();
        }
    }

    private boolean duplicatedSlug(Collection<JHipsterModuleResource> modulesResources) {
        return modulesResources.stream().map(JHipsterModuleResource::slug).collect(Collectors.toSet()).size() != modulesResources.size();
    }

    public Stream<JHipsterModuleResource> stream() {
        return this.resources.values().stream();
    }

    public JHipsterModuleResource get(JHipsterModuleSlug slug) {
        this.assertKnownSlug(slug);
        return this.resources.get(slug);
    }

    public JHipsterModule build(JHipsterModuleSlug slug, JHipsterModuleProperties properties) {
        Assert.notNull("slug", slug);
        Assert.notNull("properties", properties);
        return this.get(slug).factory().create(properties);
    }

    private void assertKnownSlug(JHipsterModuleSlug slug) {
        Assert.notNull("slug", slug);
        if (!this.resources.containsKey(slug)) {
            throw new UnknownSlugException(slug);
        }
    }

    private record DisplayHiddenResources(Collection<JHipsterModuleResource> displayed, Collection<JHipsterModuleResource> hidden) {
        public Stream<JHipsterModuleResource> displayedStream() {
            return this.displayed().stream();
        }

        private boolean hasHiddenResources() {
            return !this.hidden().isEmpty();
        }

        private String hiddenSlugs() {
            return this.hidden().stream().map(hidden -> hidden.slug().get()).collect(Collectors.joining(", "));
        }
    }
}

