/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.infrastructure.secondary;

import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import tech.jhipster.lite.error.domain.Assert;
import tech.jhipster.lite.module.domain.JHipsterModuleApplied;
import tech.jhipster.lite.module.domain.JHipsterModuleChanges;
import tech.jhipster.lite.module.domain.JHipsterModulesRepository;
import tech.jhipster.lite.module.domain.ProjectFilesReader;
import tech.jhipster.lite.module.domain.javaproperties.SpringPropertyType;
import tech.jhipster.lite.module.domain.landscape.JHipsterLandscape;
import tech.jhipster.lite.module.domain.npm.NpmVersions;
import tech.jhipster.lite.module.domain.postaction.JHipsterModuleExecutionContext;
import tech.jhipster.lite.module.domain.resource.JHipsterModulesResources;
import tech.jhipster.lite.module.infrastructure.secondary.FileSystemJHipsterModuleFiles;
import tech.jhipster.lite.module.infrastructure.secondary.FileSystemPackageJsonHandler;
import tech.jhipster.lite.module.infrastructure.secondary.FileSystemReplacer;
import tech.jhipster.lite.module.infrastructure.secondary.FileSystemSpringCommentsCommandsHandler;
import tech.jhipster.lite.module.infrastructure.secondary.FileSystemSpringFactoriesCommandsHandler;
import tech.jhipster.lite.module.infrastructure.secondary.FileSystemSpringPropertiesCommandsHandler;
import tech.jhipster.lite.module.infrastructure.secondary.javadependency.FileSystemJavaBuildCommandsHandler;
import tech.jhipster.lite.project.infrastructure.primary.JavaProjects;

@Repository
class FileSystemJHipsterModulesRepository
implements JHipsterModulesRepository {
    public static final String DEFAULT_MAIN_FOLDER = "src/main/resources/config/";
    public static final String DEFAULT_TEST_FOLDER = "src/test/resources/config/";
    public static final String TEST_META_INF_FOLDER = "src/test/resources/META-INF/";
    private final JavaProjects projects;
    private final JHipsterModulesResources resources;
    private final FileSystemJHipsterModuleFiles files;
    private final FileSystemJavaBuildCommandsHandler javaBuild;
    private final FileSystemSpringPropertiesCommandsHandler springProperties;
    private final FileSystemSpringCommentsCommandsHandler springComments;
    private final FileSystemSpringFactoriesCommandsHandler springFactories;
    private final FileSystemPackageJsonHandler packageJson;
    private final FileSystemReplacer replacer;
    private final JHipsterLandscape landscape;

    public static Map<SpringPropertyType, List<String>> buildPaths() {
        return Map.of(SpringPropertyType.MAIN_PROPERTIES, List.of(DEFAULT_MAIN_FOLDER, "src/main/resources/"), SpringPropertyType.MAIN_BOOTSTRAP_PROPERTIES, List.of(DEFAULT_MAIN_FOLDER, "src/main/resources/"), SpringPropertyType.TEST_PROPERTIES, List.of(DEFAULT_TEST_FOLDER, "src/test/resources/"), SpringPropertyType.TEST_BOOTSTRAP_PROPERTIES, List.of(DEFAULT_TEST_FOLDER, "src/test/resources/"));
    }

    public FileSystemJHipsterModulesRepository(ProjectFilesReader filesReader, NpmVersions npmVersions, JavaProjects projects, JHipsterModulesResources resources) {
        this.projects = projects;
        this.resources = resources;
        this.landscape = JHipsterLandscape.from(resources);
        this.files = new FileSystemJHipsterModuleFiles(filesReader);
        this.javaBuild = new FileSystemJavaBuildCommandsHandler();
        this.springProperties = new FileSystemSpringPropertiesCommandsHandler();
        this.springComments = new FileSystemSpringCommentsCommandsHandler();
        this.springFactories = new FileSystemSpringFactoriesCommandsHandler();
        this.packageJson = new FileSystemPackageJsonHandler(npmVersions);
        this.replacer = new FileSystemReplacer();
    }

    @Override
    public void apply(JHipsterModuleChanges changes) {
        Assert.notNull("changes", changes);
        changes.preActions().run();
        this.files.create(changes.projectFolder(), changes.filesToAdd());
        this.files.move(changes.projectFolder(), changes.filesToMove());
        this.files.delete(changes.projectFolder(), changes.filesToDelete());
        this.javaBuild.handle(changes.indentation(), changes.projectFolder(), changes.javaBuildCommands());
        this.springProperties.handle(changes.projectFolder(), changes.springProperties());
        this.springComments.handle(changes.projectFolder(), changes.springComments(), changes.springPropertiesBlockComments());
        this.springFactories.handle(changes.projectFolder(), changes.springFactories());
        this.packageJson.handle(changes.indentation(), changes.projectFolder(), changes.packageJson());
        this.replacer.handle(changes.projectFolder(), changes.mandatoryReplacements());
        this.replacer.handle(changes.projectFolder(), changes.optionalReplacements());
        changes.postActions().run(new JHipsterModuleExecutionContext(changes.projectFolder()));
    }

    @Override
    public void applied(JHipsterModuleApplied moduleApplied) {
        this.projects.moduleApplied(moduleApplied);
    }

    @Override
    public JHipsterModulesResources resources() {
        return this.resources;
    }

    @Override
    public JHipsterLandscape landscape() {
        return this.landscape;
    }
}

