/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.ci.github.actions.infrastructure.primary;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.lite.generator.ci.github.actions.application.GitHubActionsApplicationService;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleOrganization;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.shared.slug.domain.JHLiteFeatureSlug;
import tech.jhipster.lite.shared.slug.domain.JHLiteModuleSlug;

@Configuration
class GitHubActionsModuleConfiguration {
    private static final String CI_TAG = "ci";
    private static final String GITHUB_TAG = "github";
    private static final String CONTINUOUS_INTEGRATION_GROUP_DOC = "Continuous Integration";

    GitHubActionsModuleConfiguration() {
    }

    @Bean
    JHipsterModuleResource gitHubActionsMavenModule(GitHubActionsApplicationService gitHubActions) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.GITHUB_ACTIONS_MAVEN).withoutProperties().apiDoc(CONTINUOUS_INTEGRATION_GROUP_DOC, "Add GitHub Actions for Maven Build").organization(JHipsterModuleOrganization.builder().feature(JHLiteFeatureSlug.GITHUB_ACTIONS).addDependency(JHLiteModuleSlug.MAVEN_JAVA).build()).tags(CI_TAG, GITHUB_TAG).factory(gitHubActions::buildGitHubActionsMavenModule);
    }

    @Bean
    JHipsterModuleResource gitHubActionsGradleModule(GitHubActionsApplicationService gitHubActions) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.GITHUB_ACTIONS_GRADLE).withoutProperties().apiDoc(CONTINUOUS_INTEGRATION_GROUP_DOC, "Add GitHub Actions for Gradle Build").organization(JHipsterModuleOrganization.builder().feature(JHLiteFeatureSlug.GITHUB_ACTIONS).addDependency(JHLiteModuleSlug.GRADLE_JAVA).build()).tags(CI_TAG, GITHUB_TAG).factory(gitHubActions::buildGitHubActionsGradleModule);
    }
}

