/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.ci.gitlab.infrastructure.primary;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.lite.generator.ci.gitlab.application.GitLabCiApplicationService;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleOrganization;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.shared.slug.domain.JHLiteFeatureSlug;
import tech.jhipster.lite.shared.slug.domain.JHLiteModuleSlug;

@Configuration
class GitLabCiModuleConfiguration {
    private static final String CI_TAG = "ci";
    private static final String GITLAB_TAG = "gitlab";
    private static final String CONTINUOUS_INTEGRATION_GROUP_DOC = "Continuous Integration";

    GitLabCiModuleConfiguration() {
    }

    @Bean
    JHipsterModuleResource gitLabCiMavenModule(GitLabCiApplicationService gitlabCi) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.GITLAB_CI_MAVEN).withoutProperties().apiDoc(CONTINUOUS_INTEGRATION_GROUP_DOC, "Add GitLab CI for Maven Build").organization(JHipsterModuleOrganization.builder().feature(JHLiteFeatureSlug.GITLAB_CI).addDependency(JHLiteModuleSlug.MAVEN_JAVA).build()).tags(CI_TAG, GITLAB_TAG).factory(gitlabCi::buildGitLabCiMavenModule);
    }

    @Bean
    JHipsterModuleResource gitLabCiGradleModule(GitLabCiApplicationService gitlabCi) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.GITLAB_CI_GRADLE).withoutProperties().apiDoc(CONTINUOUS_INTEGRATION_GROUP_DOC, "Add GitLab CI for Gradle Build").organization(JHipsterModuleOrganization.builder().feature(JHLiteFeatureSlug.GITLAB_CI).addDependency(JHLiteModuleSlug.GRADLE_JAVA).build()).tags(CI_TAG, GITLAB_TAG).factory(gitlabCi::buildGitLabCiGradleModule);
    }
}

