/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.client.svelte.core.domain;

import tech.jhipster.lite.module.domain.Indentation;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.npm.JHLiteNpmVersionSource;
import tech.jhipster.lite.module.domain.npm.NpmLazyInstaller;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleOptionalReplacementsFactory;
import tech.jhipster.lite.shared.error.domain.Assert;

public class SvelteModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("client/svelte");
    private static final String ENGINES_NEEDLE = "  \"engines\":";
    private static final JHipsterSource PRIMARY_MAIN_SOURCE = SOURCE.append("src/main/webapp/app/common/primary/app");
    private static final JHipsterDestination PRIMARY_MAIN_DESTINATION = JHipsterModule.to("src/main/webapp/app/common/primary/app");
    private static final JHipsterSource CLIENT_COMMON = JHipsterModule.from("client/common");
    private static final JHipsterSource PRIMARY_TEST_SOURCE = SOURCE.append("src/test/unit/common/primary/app");
    private static final JHipsterDestination PRIMARY_TEST_DESTINATION = JHipsterModule.to("src/test/webapp/unit/common/primary/app");
    private final NpmLazyInstaller npmLazyInstaller;

    public SvelteModuleFactory(NpmLazyInstaller npmLazyInstaller) {
        this.npmLazyInstaller = npmLazyInstaller;
    }

    public JHipsterModule buildSvelteModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return ((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleOptionalReplacementsFactoryBuilder)((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleFileOptionalReplacementsFactoryBuilder)JHipsterModule.moduleBuilder(properties).preCommitActions(JHipsterModule.stagedFilesFilter("{src/**/,}*.ts"), JHipsterModule.preCommitCommands("eslint --fix", "prettier --write")).gitIgnore().comment("Svelte").pattern(".svelte-kit/").and().packageJson().addDependency(JHipsterModule.packageName("svelte-navigator"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("@babel/preset-env"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("@sveltejs/adapter-static"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("@sveltejs/kit"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("@testing-library/svelte"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("@typescript-eslint/eslint-plugin"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("@typescript-eslint/parser"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("@vitest/coverage-istanbul"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("babel-plugin-transform-vite-meta-env"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("eslint"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("eslint-config-prettier"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("eslint-plugin-svelte3"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("jsdom"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("prettier"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("prettier-plugin-svelte"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("svelte"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("svelte-check"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("svelte-preprocess"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("tslib"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("typescript"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("vite"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("vitest"), JHLiteNpmVersionSource.SVELTE).addDevDependency(JHipsterModule.packageName("vitest-sonar-reporter"), JHLiteNpmVersionSource.SVELTE).addScript(JHipsterModule.scriptKey("dev"), JHipsterModule.scriptCommand("vite dev --port 9000")).addScript(JHipsterModule.scriptKey("start"), JHipsterModule.scriptCommand("vite dev --port 9000")).addScript(JHipsterModule.scriptKey("build"), JHipsterModule.scriptCommand("vite build")).addScript(JHipsterModule.scriptKey("package"), JHipsterModule.scriptCommand("vite package")).addScript(JHipsterModule.scriptKey("preview"), JHipsterModule.scriptCommand("vite preview")).addScript(JHipsterModule.scriptKey("check"), JHipsterModule.scriptCommand("svelte-check --tsconfig ./tsconfig.json")).addScript(JHipsterModule.scriptKey("check:watch"), JHipsterModule.scriptCommand("svelte-check --tsconfig ./tsconfig.json --watch")).addScript(JHipsterModule.scriptKey("lint"), JHipsterModule.scriptCommand("prettier --ignore-path .gitignore --check && eslint --ignore-path .gitignore .")).addScript(JHipsterModule.scriptKey("format"), JHipsterModule.scriptCommand("prettier --ignore-path .gitignore --write")).addScript(JHipsterModule.scriptKey("test"), JHipsterModule.scriptCommand("npm run test:watch")).addScript(JHipsterModule.scriptKey("test:coverage"), JHipsterModule.scriptCommand("vitest run --coverage")).addScript(JHipsterModule.scriptKey("test:watch"), JHipsterModule.scriptCommand("vitest --")).and().postActions().add(context -> this.npmLazyInstaller.runInstallIn(context.projectFolder())).and().optionalReplacements().in(JHipsterModule.path("package.json")).add(JHipsterModule.lineBeforeText(ENGINES_NEEDLE), SvelteModuleFactory.type(properties.indentation()))).and()).and().files().add(SOURCE.file(".eslintrc.cjs"), JHipsterModule.to(".eslintrc.cjs")).add(SOURCE.file("tsconfig.json"), JHipsterModule.to("tsconfig.json")).add(SOURCE.file("vite.config.js"), JHipsterModule.to("vite.config.js")).add(SOURCE.append("src/main/webapp/routes").template("+page.svelte"), JHipsterModule.to("src/main/webapp/routes/+page.svelte")).add(PRIMARY_MAIN_SOURCE.template("App.svelte"), PRIMARY_MAIN_DESTINATION.append("App.svelte")).add(PRIMARY_TEST_SOURCE.template("App.spec.ts"), PRIMARY_TEST_DESTINATION.append("App.spec.ts")).batch(CLIENT_COMMON, JHipsterModule.to(".")).addFile(".eslintignore").addFile(".npmrc").and().batch(SOURCE, JHipsterModule.to(".")).addTemplate("svelte.config.js").addTemplate("vitest.config.ts").and().batch(SOURCE.file("src/main/webapp"), JHipsterModule.to("src/main/webapp")).addTemplate("app.html").addTemplate("app.d.ts").and().batch(SOURCE.file("src/main/webapp/assets"), JHipsterModule.to("src/main/webapp/assets")).addFile("JHipster-Lite-neon-orange.png").addFile("svelte-logo.png").and().and().build();
    }

    private static String type(Indentation indentation) {
        return indentation.spaces() + "\"type\": \"module\",";
    }
}

