/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.client.tikui.domain;

import java.util.Collection;
import java.util.Set;
import java.util.regex.Pattern;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.npm.JHLiteNpmVersionSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleOptionalReplacementsFactory;
import tech.jhipster.lite.module.domain.replacement.RegexNeedleAfterReplacer;
import tech.jhipster.lite.module.domain.replacement.ReplacementCondition;

public class TikuiModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("client/tikui");
    private static final JHipsterSource STYLE_SOURCE = SOURCE.append("style");
    private static final JHipsterDestination STYLE_DESTINATION = JHipsterModule.to("src/main/style");
    private static final String ATOM = "atom";
    private static final String ATOM_BUTTON = "atom/button";
    private static final String ATOM_INPUT_TEXT = "atom/input-text";
    private static final String ATOM_LABEL = "atom/label";
    private static final String ATOM_PAGE_TITLE = "atom/page-title";
    private static final String ATOM_PARAGRAPH = "atom/paragraph";
    private static final String MOLECULE = "molecule";
    private static final String MOLECULE_FIELD = "molecule/field";
    private static final String MOLECULE_TOAST = "molecule/toast";
    private static final String ORGANISM = "organism";
    private static final String ORGANISM_COLUMNS = "organism/columns";
    private static final String ORGANISM_LINES = "organism/lines";
    private static final String ORGANISM_TOASTS = "organism/toasts";
    private static final String TEMPLATE = "template";
    private static final String TEMPLATE_TEMPLATE_PAGE = "template/template-page";
    private static final String TEMPLATE_TOASTING = "template/toasting";
    private static final String QUARK = "quark";

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        return ((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleOptionalReplacementsFactoryBuilder)((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleFileOptionalReplacementsFactoryBuilder)((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleOptionalReplacementsFactoryBuilder)((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleFileOptionalReplacementsFactoryBuilder)((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleOptionalReplacementsFactoryBuilder)((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleFileOptionalReplacementsFactoryBuilder)((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleOptionalReplacementsFactoryBuilder)((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleFileOptionalReplacementsFactoryBuilder)((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleFileOptionalReplacementsFactoryBuilder)JHipsterModule.moduleBuilder(properties).preCommitActions(JHipsterModule.stagedFilesFilter("*.pug"), JHipsterModule.preCommitCommands("prettier --write")).preCommitActions(JHipsterModule.stagedFilesFilter("*.{css,scss}"), JHipsterModule.preCommitCommands("stylelint --fix --allow-empty-input", "prettier --write")).packageJson().addDependency(JHipsterModule.packageName("@tikui/core"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("@prettier/plugin-pug"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("stylelint"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("stylelint-config-concentric-order"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("stylelint-config-standard-scss"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("stylelint-order"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("tikuidoc-tikui"), JHLiteNpmVersionSource.COMMON).addScript(JHipsterModule.scriptKey("build:tikui"), JHipsterModule.scriptCommand("tikui-core build")).addScript(JHipsterModule.scriptKey("dev:tikui"), JHipsterModule.scriptCommand("tikui-core serve")).and().files().add(SOURCE.template("tikuiconfig.json"), JHipsterModule.to("tikuiconfig.json")).add(SOURCE.template(".stylelintrc.json"), JHipsterModule.to(".stylelintrc.json")).batch(STYLE_SOURCE, STYLE_DESTINATION).addTemplate("tikui.scss").addTemplate("favicon.ico").addTemplate("index.pug").addTemplate("layout.pug").addTemplate("layout-documentation.pug").and().batch(STYLE_SOURCE.append(ATOM), STYLE_DESTINATION.append(ATOM)).addTemplate("_atom.scss").addTemplate("atom.pug").and().batch(STYLE_SOURCE.append(ATOM_BUTTON), STYLE_DESTINATION.append(ATOM_BUTTON)).addTemplates(TikuiModuleFactory.componentFiles("button")).and().batch(STYLE_SOURCE.append(ATOM_INPUT_TEXT), STYLE_DESTINATION.append(ATOM_INPUT_TEXT)).addTemplates(TikuiModuleFactory.componentFiles("input-text")).and().batch(STYLE_SOURCE.append(ATOM_LABEL), STYLE_DESTINATION.append(ATOM_LABEL)).addTemplates(TikuiModuleFactory.componentFiles("label")).and().batch(STYLE_SOURCE.append(ATOM_PAGE_TITLE), STYLE_DESTINATION.append(ATOM_PAGE_TITLE)).addTemplates(TikuiModuleFactory.componentFiles("page-title")).and().batch(STYLE_SOURCE.append(ATOM_PARAGRAPH), STYLE_DESTINATION.append(ATOM_PARAGRAPH)).addTemplates(TikuiModuleFactory.componentFiles("paragraph")).and().batch(STYLE_SOURCE.append(MOLECULE), STYLE_DESTINATION.append(MOLECULE)).addTemplate("_molecule.scss").addTemplate("molecule.pug").and().batch(STYLE_SOURCE.append(MOLECULE_FIELD), STYLE_DESTINATION.append(MOLECULE_FIELD)).addTemplates(TikuiModuleFactory.componentFiles("field")).and().batch(STYLE_SOURCE.append(MOLECULE_TOAST), STYLE_DESTINATION.append(MOLECULE_TOAST)).addTemplates(TikuiModuleFactory.componentFiles("toast")).and().batch(STYLE_SOURCE.append(ORGANISM), STYLE_DESTINATION.append(ORGANISM)).addTemplate("_organism.scss").addTemplate("organism.pug").and().batch(STYLE_SOURCE.append(ORGANISM_COLUMNS), STYLE_DESTINATION.append(ORGANISM_COLUMNS)).addTemplates(TikuiModuleFactory.componentFiles("columns")).and().batch(STYLE_SOURCE.append(ORGANISM_LINES), STYLE_DESTINATION.append(ORGANISM_LINES)).addTemplates(TikuiModuleFactory.componentFiles("lines")).and().batch(STYLE_SOURCE.append(ORGANISM_TOASTS), STYLE_DESTINATION.append(ORGANISM_TOASTS)).addTemplates(TikuiModuleFactory.componentFiles("toasts")).and().batch(STYLE_SOURCE.append(QUARK), STYLE_DESTINATION.append(QUARK)).addTemplate("_placeholder.scss").addTemplate("_spacing.scss").and().batch(STYLE_SOURCE.append(TEMPLATE), STYLE_DESTINATION.append(TEMPLATE)).addTemplate("_template.scss").addTemplate("template.pug").and().batch(STYLE_SOURCE.append(TEMPLATE_TEMPLATE_PAGE), STYLE_DESTINATION.append(TEMPLATE_TEMPLATE_PAGE)).addTemplates(TikuiModuleFactory.componentFiles("template-page")).and().batch(STYLE_SOURCE.append(TEMPLATE_TOASTING), STYLE_DESTINATION.append(TEMPLATE_TOASTING)).addTemplates(TikuiModuleFactory.componentFiles("toasting")).and().batch(STYLE_SOURCE.append("token"), STYLE_DESTINATION.append("token")).addTemplate("spacing/_spacings.scss").addTemplate("spacing/_vars.scss").addTemplate("_animations.scss").addTemplate("_color.scss").addTemplate("_font.scss").addTemplate("_gradient.scss").addTemplate("_radius.scss").addTemplate("_size.scss").addTemplate("_token.scss").and().batch(STYLE_SOURCE.append("variables"), STYLE_DESTINATION.append("variables")).addTemplate("_breakpoint.scss").and().and().optionalReplacements().in(JHipsterModule.path("vite.config.ts")).add(TikuiModuleFactory.existingProxyReplacer(), TikuiModuleFactory.proxyForStyle(properties))).add(TikuiModuleFactory.newProxyReplacer(), TikuiModuleFactory.newProxyForStyle(properties))).and()).in(JHipsterModule.path("proxy.conf.json")).add(JHipsterModule.lineBeforeText("\"/api\":"), this.styleProxyConf(properties))).and()).in(JHipsterModule.path("src/main/webapp/index.html")).add(JHipsterModule.lineBeforeText("</head>"), this.tikuiLink(properties))).and()).in(JHipsterModule.path(".prettierrc")).add(JHipsterModule.lineAfterText("plugins:"), this.pugPlugin(properties))).and()).and().gitIgnore().pattern(".tikui-cache").and().build();
    }

    private static Collection<String> componentFiles(String name) {
        return Set.of("_" + name + ".scss", name + ".code.pug", name + ".md", name + ".mixin.pug", name + ".render.pug");
    }

    private static RegexNeedleAfterReplacer newProxyReplacer() {
        return new RegexNeedleAfterReplacer(ReplacementCondition.notContaining("proxy:"), Pattern.compile("port:\\s*9000,", 8));
    }

    private static RegexNeedleAfterReplacer existingProxyReplacer() {
        return new RegexNeedleAfterReplacer((contentBeforeReplacement, replacement) -> contentBeforeReplacement.contains("proxy:"), Pattern.compile("proxy:\\s*\\{", 8));
    }

    private String tikuiLink(JHipsterModuleProperties properties) {
        return properties.indentation().times(2) + "<link rel=\"stylesheet\" href=\"/style/tikui.css\" />";
    }

    private String pugPlugin(JHipsterModuleProperties properties) {
        return properties.indentation().times(1) + "- '@prettier/plugin-pug'";
    }

    private static String newProxyForStyle(JHipsterModuleProperties properties) {
        return properties.indentation().times(2) + "proxy: {" + "\n" + TikuiModuleFactory.proxyForStyle(properties) + "\n" + properties.indentation().times(2) + "},";
    }

    private static String proxyForStyle(JHipsterModuleProperties properties) {
        return "{S}{S}{S}'/style': {\n{S}{S}{S}{S}ws: true,\n{S}{S}{S}{S}changeOrigin: true,\n{S}{S}{S}{S}rewrite: path => path.replace('/style', ''),\n{S}{S}{S}{S}target: 'http://localhost:9005',\n{S}{S}{S}},".replace("{S}", properties.indentation().times(1));
    }

    private String styleProxyConf(JHipsterModuleProperties properties) {
        return "{S}\"/style\": {\n{S}{S}\"target\": \"http://localhost:9005\",\n{S}{S}\"secure\": false\n{S}},\n".replace("{S}", properties.indentation().times(1));
    }
}

