/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.client.tools.cypress.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.npm.JHLiteNpmVersionSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class CypressModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("client/common/cypress");
    private static final JHipsterDestination CYPRESS_COMPONENT_TESTS = JHipsterModule.to("src/test/webapp/component");
    private static final JHipsterDestination CYPRESS_E2E_TESTS = JHipsterModule.to("src/test/webapp/e2e");
    private static final String HOME = "home";
    private static final String UTILS = "utils";

    public JHipsterModule buildComponentTestsModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return CypressModuleFactory.commonCypressModuleBuilder(properties, CYPRESS_COMPONENT_TESTS).packageJson().addDevDependency(JHipsterModule.packageName("start-server-and-test"), JHLiteNpmVersionSource.COMMON).addScript(JHipsterModule.scriptKey("test:component"), JHipsterModule.scriptCommand("start-server-and-test start http://localhost:9000 'cypress open --e2e --config-file src/test/webapp/component/cypress-config.ts'")).addScript(JHipsterModule.scriptKey("test:component:headless"), JHipsterModule.scriptCommand("start-server-and-test start http://localhost:9000 'cypress run --headless --config-file src/test/webapp/component/cypress-config.ts'")).and().context().put("cypressTestDirectory", "component").and().build();
    }

    public JHipsterModule buildE2ETestsModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return CypressModuleFactory.commonCypressModuleBuilder(properties, CYPRESS_E2E_TESTS).packageJson().addScript(JHipsterModule.scriptKey("e2e"), JHipsterModule.scriptCommand("cypress open --e2e --config-file src/test/webapp/e2e/cypress-config.ts")).addScript(JHipsterModule.scriptKey("e2e:headless"), JHipsterModule.scriptCommand("cypress run --headless --config-file src/test/webapp/e2e/cypress-config.ts")).and().context().put("cypressTestDirectory", "e2e").and().build();
    }

    private static JHipsterModule.JHipsterModuleBuilder commonCypressModuleBuilder(JHipsterModuleProperties properties, JHipsterDestination destinationFolder) {
        return JHipsterModule.moduleBuilder(properties).packageJson().addDevDependency(JHipsterModule.packageName("cypress"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("eslint-plugin-cypress"), JHLiteNpmVersionSource.COMMON).and().files().batch(SOURCE, destinationFolder).addTemplate("cypress-config.ts").addFile("tsconfig.json").and().batch(SOURCE.append(HOME), destinationFolder.append(HOME)).addTemplate("Home.spec.ts").and().batch(SOURCE.append(UTILS), destinationFolder.append(UTILS)).addFile("Interceptor.ts").addFile("DataSelector.ts").and().and();
    }
}

