/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.client.tools.playwright.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.npm.JHLiteNpmVersionSource;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class PlaywrightModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("client/common/playwright");
    private static final JHipsterDestination WEBAPP_COMPONENT_TESTS = JHipsterModule.to("src/test/webapp/component/");
    private static final JHipsterDestination WEBAPP_E2E_TESTS = JHipsterModule.to("src/test/webapp/e2e/");
    private static final String PLAYWRIGHT_TESTS = "common/primary/app";

    public JHipsterModule buildComponentTestsModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return PlaywrightModuleFactory.commonPlaywrightModuleBuilder(properties, WEBAPP_COMPONENT_TESTS).packageJson().addDevDependency(JHipsterModule.packageName("start-server-and-test"), JHLiteNpmVersionSource.COMMON).addScript(JHipsterModule.scriptKey("test:component"), JHipsterModule.scriptCommand("start-server-and-test start http://localhost:9000 'playwright test --ui --config src/test/webapp/component/playwright.config.ts'")).addScript(JHipsterModule.scriptKey("test:component:headless"), JHipsterModule.scriptCommand("start-server-and-test start http://localhost:9000 'playwright test --config src/test/webapp/component/playwright.config.ts'")).and().context().put("reportSubDirectory", "component-tests").put("resultsSubDirectory", "component-tests").and().build();
    }

    public JHipsterModule buildE2ETestsModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        return PlaywrightModuleFactory.commonPlaywrightModuleBuilder(properties, WEBAPP_E2E_TESTS).packageJson().addScript(JHipsterModule.scriptKey("e2e"), JHipsterModule.scriptCommand("playwright test --ui --config src/test/webapp/e2e/playwright.config.ts")).addScript(JHipsterModule.scriptKey("e2e:headless"), JHipsterModule.scriptCommand("playwright test --config src/test/webapp/e2e/playwright.config.ts")).and().context().put("reportSubDirectory", "e2e-tests").put("resultsSubDirectory", "e2e-tests").and().build();
    }

    private static JHipsterModule.JHipsterModuleBuilder commonPlaywrightModuleBuilder(JHipsterModuleProperties properties, JHipsterDestination destinationFolder) {
        return JHipsterModule.moduleBuilder(properties).packageJson().addDevDependency(JHipsterModule.packageName("@playwright/test"), JHLiteNpmVersionSource.COMMON).and().files().add(SOURCE.template("playwright.config.ts"), destinationFolder.append("playwright.config.ts")).batch(SOURCE.append(PLAYWRIGHT_TESTS), destinationFolder.append(PLAYWRIGHT_TESTS)).addTemplate("Home.spec.ts").addFile("Home-Page.ts").and().and();
    }
}

