/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.prettier.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.npm.JHLiteNpmVersionSource;
import tech.jhipster.lite.module.domain.npm.NpmLazyInstaller;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;

public class PrettierModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("prettier");
    private static final JHipsterDestination DESTINATION = JHipsterModule.to(".");
    private final NpmLazyInstaller npmLazyInstaller;

    public PrettierModuleFactory(NpmLazyInstaller npmLazyInstaller) {
        this.npmLazyInstaller = npmLazyInstaller;
    }

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        return JHipsterModule.moduleBuilder(properties).context().put("dasherizedBaseName", properties.projectBaseName().kebabCase()).put("endOfLine", this.endOfLine(properties)).and().files().batch(SOURCE, DESTINATION).addFile(".prettierignore").addTemplate(".prettierrc").and().and().packageJson().addDevDependency(JHipsterModule.packageName("@prettier/plugin-xml"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("prettier"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("prettier-plugin-gherkin"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("prettier-plugin-java"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("prettier-plugin-organize-imports"), JHLiteNpmVersionSource.COMMON).addDevDependency(JHipsterModule.packageName("prettier-plugin-packagejson"), JHLiteNpmVersionSource.COMMON).addScript(JHipsterModule.scriptKey("prettier:check"), JHipsterModule.scriptCommand("prettier --check .")).addScript(JHipsterModule.scriptKey("prettier:format"), JHipsterModule.scriptCommand("prettier --write .")).and().postActions().add(context -> this.npmLazyInstaller.runInstallIn(context.projectFolder())).and().preCommitActions(JHipsterModule.stagedFilesFilter("*.{md,json*,yml,html,css,scss,java,xml,feature}"), JHipsterModule.preCommitCommands("['prettier --write']")).build();
    }

    private String endOfLine(JHipsterModuleProperties properties) {
        return properties.getOrDefaultString("endOfLine", "lf");
    }
}

