/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.javatool.protobuf.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.PreCommitCommands;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.gradleplugin.GradleCommunityPlugin;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPlugin;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class ProtobufModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/javatool/protobuf");
    private static final JHipsterSource MAIN_SOURCE = SOURCE.append("main");
    private static final JHipsterSource TEST_SOURCE = SOURCE.append("test");
    private static final String PROTOBUF_PACKAGE = "shared/protobuf";
    private static final VersionSlug PROTOBUF_VERSION_SLUG = JHipsterModule.versionSlug("protobuf");
    private static final GroupId PROTOBUF_GROUPID = JHipsterModule.groupId("com.google.protobuf");

    public JHipsterModule buildProtobufModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        JHipsterDestination mainDestination = JHipsterModule.toSrcMainJava().append(properties.packagePath()).append(PROTOBUF_PACKAGE);
        JHipsterDestination testDestination = JHipsterModule.toSrcTestJava().append(properties.packagePath()).append(PROTOBUF_PACKAGE);
        return JHipsterModule.moduleBuilder(properties).files().add(MAIN_SOURCE.template("package-info.java"), mainDestination.append("package-info.java")).add(MAIN_SOURCE.template("ProtobufDatesReader.java"), mainDestination.append("infrastructure/primary/ProtobufDatesReader.java")).add(MAIN_SOURCE.template("ProtobufDatesWriter.java"), mainDestination.append("infrastructure/secondary/ProtobufDatesWriter.java")).add(MAIN_SOURCE.append(".gitkeep"), JHipsterModule.to("src/main/proto/.gitkeep")).add(TEST_SOURCE.template("ProtobufDatesReaderTest.java"), testDestination.append("infrastructure/primary/ProtobufDatesReaderTest.java")).add(TEST_SOURCE.template("ProtobufDatesWriterTest.java"), testDestination.append("infrastructure/secondary/ProtobufDatesWriterTest.java")).and().javaDependencies().addDependency(PROTOBUF_GROUPID, JHipsterModule.artifactId("protobuf-java"), PROTOBUF_VERSION_SLUG).addTestDependency(PROTOBUF_GROUPID, JHipsterModule.artifactId("protobuf-java-util"), PROTOBUF_VERSION_SLUG).and().mavenPlugins().pluginManagement(this.protobufMavenPluginManagement()).plugin(this.protobufMavenPluginBuilder().build()).and().gradlePlugins().plugin(ProtobufModuleFactory.protobufGradlePlugin()).and().build();
    }

    private static GradleCommunityPlugin protobufGradlePlugin() {
        return JHipsterModule.gradleCommunityPlugin().id("com.google.protobuf").pluginSlug("protobuf").versionSlug("protobuf-plugin").configuration("protobuf {\n  protoc {\n    artifact = \"com.google.protobuf:protoc:${libs.versions.protobuf.asProvider().get()}\"\n  }\n}\n").build();
    }

    private MavenPlugin protobufMavenPluginManagement() {
        return this.protobufMavenPluginBuilder().versionSlug("protobuf-maven-plugin").configuration("<protocVersion>${protobuf.version}</protocVersion>\n<sourceDirectories>\n  <sourceDirectory>src/main/proto</sourceDirectory>\n</sourceDirectories>\n<failOnMissingSources>false</failOnMissingSources>\n").addExecution(JHipsterModule.pluginExecution().goals("generate")).build();
    }

    private MavenPlugin.MavenPluginOptionalBuilder protobufMavenPluginBuilder() {
        return JHipsterModule.mavenPlugin().groupId("io.github.ascopes").artifactId("protobuf-maven-plugin");
    }

    public JHipsterModule buildProtobufBackwardsCompatibilityCheckModule(JHipsterModuleProperties properties) {
        return JHipsterModule.moduleBuilder(properties).files().add(MAIN_SOURCE.append("proto.lock"), JHipsterModule.to("src/main/proto/proto.lock")).and().mavenBuildExtensions().addExtension(JHipsterModule.groupId("kr.motd.maven"), JHipsterModule.artifactId("os-maven-plugin"), JHipsterModule.versionSlug("os-maven-plugin")).and().mavenPlugins().pluginManagement(this.protoBackwardsCompatibilityMavenPluginManagement()).plugin(this.protoBackwardsCompatibilityMavenPluginBuilder().build()).and().preCommitActions(JHipsterModule.stagedFilesFilter("*.proto"), new PreCommitCommands("() => ['mvn proto-backwards-compatibility:backwards-compatibility-check', 'git add *proto.lock']")).build();
    }

    private MavenPlugin protoBackwardsCompatibilityMavenPluginManagement() {
        return this.protoBackwardsCompatibilityMavenPluginBuilder().versionSlug("proto-backwards-compatibility").addExecution(JHipsterModule.pluginExecution().goals("backwards-compatibility-check")).build();
    }

    private MavenPlugin.MavenPluginOptionalBuilder protoBackwardsCompatibilityMavenPluginBuilder() {
        return JHipsterModule.mavenPlugin().groupId("com.salesforce.servicelibs").artifactId("proto-backwards-compatibility");
    }
}

