/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.core.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterDestination;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.gradleplugin.GradleMainBuildPlugin;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyType;
import tech.jhipster.lite.module.domain.mavenplugin.MavenPlugin;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleOptionalReplacementsFactory;
import tech.jhipster.lite.module.domain.replacement.ReplacementCondition;
import tech.jhipster.lite.module.domain.replacement.TextNeedleBeforeReplacer;
import tech.jhipster.lite.shared.error.domain.Assert;

public class SpringBootCoreModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/core");
    private static final JHipsterSource MAIN_SOURCE = SOURCE.append("main");
    private static final JHipsterSource TEST_SOURCE = SOURCE.append("test");
    private static final GroupId SPRING_BOOT_GROUP = JHipsterModule.groupId("org.springframework.boot");
    private static final String JUNIT_GROUP = "org.junit.jupiter";
    private static final String MOCKITO_GROUP = "org.mockito";
    private static final VersionSlug SPRING_BOOT_VERSION_SLUG = JHipsterModule.versionSlug("spring-boot");
    private static final TextNeedleBeforeReplacer DEFAULT_GOAL_REPLACER = new TextNeedleBeforeReplacer(ReplacementCondition.notContaining("<defaultGoal>"), "</build>");
    private static final JHipsterDestination MAIN_RESOURCE_DESTINATION = JHipsterModule.to("src/main/resources");
    private static final JHipsterDestination TEST_RESOURCES_DESTINATION = JHipsterModule.to("src/test/resources");

    public JHipsterModule buildModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String baseName = properties.projectBaseName().capitalized();
        String packagePath = properties.packagePath();
        JHipsterDestination testDestination = JHipsterModule.toSrcTestJava().append(packagePath);
        String fullyQualifiedMainClass = properties.basePackage().get() + "." + baseName + "App";
        String basePackageLoggingLevel = "logging.level.%s".formatted(properties.basePackage().get());
        return ((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleOptionalReplacementsFactoryBuilder)((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleFileOptionalReplacementsFactoryBuilder)JHipsterModule.moduleBuilder(properties).context().put("baseName", baseName).and().javaDependencies().removeDependency(JHipsterModule.dependencyId(JUNIT_GROUP, "junit-jupiter-engine")).removeDependency(JHipsterModule.dependencyId(JUNIT_GROUP, "junit-jupiter-params")).removeDependency(JHipsterModule.dependencyId("org.assertj", "assertj-core")).removeDependency(JHipsterModule.dependencyId(MOCKITO_GROUP, "mockito-junit-jupiter")).addDependencyManagement(this.springBootBom()).addDependency(SPRING_BOOT_GROUP, JHipsterModule.artifactId("spring-boot-starter")).addDependency(this.springBootConfigurationProcessor()).addDependency(JHipsterModule.groupId("org.apache.commons"), JHipsterModule.artifactId("commons-lang3")).addDependency(this.springBootTest()).and().mavenPlugins().pluginManagement(this.springBootPluginManagement(fullyQualifiedMainClass)).plugin(this.springBootMavenPlugin()).and().gradlePlugins().plugin(this.springBootGradlePlugin(fullyQualifiedMainClass)).and().files().add(MAIN_SOURCE.template("MainApp.java"), JHipsterModule.toSrcMainJava().append(packagePath).append(baseName + "App.java")).add(MAIN_SOURCE.template("ApplicationStartupTraces.java"), JHipsterModule.toSrcMainJava().append(packagePath).append("ApplicationStartupTraces.java")).add(TEST_SOURCE.template("IntegrationTest.java"), testDestination.append("IntegrationTest.java")).add(MAIN_SOURCE.template("logback-spring.xml"), MAIN_RESOURCE_DESTINATION.append("logback-spring.xml")).add(TEST_SOURCE.template("logback.xml"), TEST_RESOURCES_DESTINATION.append("logback.xml")).add(TEST_SOURCE.template("ApplicationStartupTracesTest.java"), JHipsterModule.toSrcTestJava().append(packagePath).append("ApplicationStartupTracesTest.java")).and().springMainProperties().set(JHipsterModule.propertyKey("spring.application.name"), JHipsterModule.propertyValue(baseName)).set(JHipsterModule.propertyKey(basePackageLoggingLevel), JHipsterModule.propertyValue("INFO")).and().springLocalProperties().set(JHipsterModule.propertyKey(basePackageLoggingLevel), JHipsterModule.propertyValue("DEBUG")).and().springTestProperties().set(JHipsterModule.propertyKey("spring.main.banner-mode"), JHipsterModule.propertyValue("off")).set(JHipsterModule.propertyKey(basePackageLoggingLevel), JHipsterModule.propertyValue("OFF")).set(JHipsterModule.propertyKey("logging.config"), JHipsterModule.propertyValue("classpath:logback.xml")).and().optionalReplacements().in(JHipsterModule.path("pom.xml")).add(DEFAULT_GOAL_REPLACER, properties.indentation().times(2) + "<defaultGoal>spring-boot:run</defaultGoal>")).and()).and().build();
    }

    private GradleMainBuildPlugin springBootGradlePlugin(String fullyQualifiedMainClass) {
        return JHipsterModule.gradleCommunityPlugin().id("org.springframework.boot").pluginSlug("spring-boot").versionSlug(SPRING_BOOT_VERSION_SLUG).configuration("defaultTasks(\"bootRun\")\n\nspringBoot {\n  mainClass = \"%s\"\n}\n".formatted(fullyQualifiedMainClass)).build();
    }

    private JavaDependency springBootBom() {
        return JavaDependency.builder().groupId(SPRING_BOOT_GROUP).artifactId("spring-boot-dependencies").versionSlug(SPRING_BOOT_VERSION_SLUG).type(JavaDependencyType.POM).scope(JavaDependencyScope.IMPORT).build();
    }

    private JavaDependency springBootConfigurationProcessor() {
        return JavaDependency.builder().groupId(SPRING_BOOT_GROUP).artifactId("spring-boot-configuration-processor").optional().build();
    }

    private JavaDependency springBootTest() {
        return JavaDependency.builder().groupId(SPRING_BOOT_GROUP).artifactId("spring-boot-starter-test").scope(JavaDependencyScope.TEST).build();
    }

    private MavenPlugin springBootPluginManagement(String fullyQualifiedMainClass) {
        return MavenPlugin.builder().groupId(SPRING_BOOT_GROUP).artifactId("spring-boot-maven-plugin").versionSlug(SPRING_BOOT_VERSION_SLUG).addExecution(JHipsterModule.pluginExecution().goals("repackage")).configuration("<mainClass>%s</mainClass>".formatted(fullyQualifiedMainClass)).build();
    }

    private MavenPlugin springBootMavenPlugin() {
        return JHipsterModule.mavenPlugin().groupId(SPRING_BOOT_GROUP).artifactId("spring-boot-maven-plugin").build();
    }
}

