/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.jooq.domain;

import tech.jhipster.lite.generator.server.springboot.database.jooq.domain.DatabaseType;
import tech.jhipster.lite.module.domain.DocumentationTitle;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.docker.DockerImageVersion;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.javaproperties.PropertyValue;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

final class CommonModuleBuilder {
    private static final PropertyValue FALSE = JHipsterModule.propertyValue(false);

    private CommonModuleBuilder() {
    }

    public static JHipsterModule.JHipsterModuleBuilder commonModuleBuilder(JHipsterModuleProperties properties, DatabaseType databaseType, DockerImageVersion dockerImage, DocumentationTitle documentationTitle, ArtifactId testContainerArtifactId) {
        Assert.notNull("properties", properties);
        Assert.notNull("databaseType", (Object)databaseType);
        Assert.notNull("dockerImage", dockerImage);
        Assert.notNull("documentationTitle", documentationTitle);
        Assert.notNull("testContainerArtifactId", testContainerArtifactId);
        String databaseId = databaseType.id();
        JHipsterSource source = JHipsterModule.from("server/springboot/database/common");
        return JHipsterModule.moduleBuilder(properties).context().put("srcMainDocker", "src/main/docker").put("databaseType", databaseId).put(databaseId + "DockerImageWithVersion", dockerImage.fullName()).and().documentation(documentationTitle, source.template("databaseType.md")).startupCommands().dockerCompose(CommonModuleBuilder.startupCommand(databaseId)).and().files().add(source.append("docker").template(databaseId + ".yml"), JHipsterModule.toSrcMainDocker().append(databaseId + ".yml")).and().javaDependencies().addDependency(JHipsterModule.groupId("org.springframework.boot"), JHipsterModule.artifactId("spring-boot-starter-jooq")).addDependency(JHipsterModule.groupId("com.zaxxer"), JHipsterModule.artifactId("HikariCP")).addDependency(CommonModuleBuilder.testContainer(testContainerArtifactId)).and().springMainProperties().set(JHipsterModule.propertyKey("spring.datasource.password"), JHipsterModule.propertyValue("")).set(JHipsterModule.propertyKey("spring.datasource.type"), JHipsterModule.propertyValue("com.zaxxer.hikari.HikariDataSource")).set(JHipsterModule.propertyKey("spring.datasource.hikari.poolName"), JHipsterModule.propertyValue("Hikari")).set(JHipsterModule.propertyKey("spring.datasource.hikari.auto-commit"), FALSE).and().springTestProperties().set(JHipsterModule.propertyKey("spring.datasource.url"), JHipsterModule.propertyValue("jdbc:tc:" + dockerImage.fullName() + ":///" + properties.projectBaseName().name())).set(JHipsterModule.propertyKey("spring.datasource.username"), JHipsterModule.propertyValue(properties.projectBaseName().name())).set(JHipsterModule.propertyKey("spring.datasource.password"), JHipsterModule.propertyValue("")).set(JHipsterModule.propertyKey("spring.datasource.driver-class-name"), JHipsterModule.propertyValue("org.testcontainers.jdbc.ContainerDatabaseDriver")).set(JHipsterModule.propertyKey("spring.datasource.hikari.maximum-pool-size"), JHipsterModule.propertyValue(2)).and();
    }

    private static String startupCommand(String databaseId) {
        return "src/main/docker/" + databaseId + ".yml";
    }

    private static JavaDependency testContainer(ArtifactId testContainerArtifactId) {
        return JHipsterModule.javaDependency().groupId("org.testcontainers").artifactId(testContainerArtifactId).dependencySlug("%s-%s".formatted("testcontainers", testContainerArtifactId)).versionSlug("testcontainers").scope(JavaDependencyScope.TEST).build();
    }
}

