/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.jooq.domain;

import tech.jhipster.lite.generator.server.springboot.database.jooq.domain.CommonModuleBuilder;
import tech.jhipster.lite.generator.server.springboot.database.jooq.domain.DatabaseType;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.docker.DockerImageVersion;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.mavenplugin.MavenBuildPhase;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacementsFactory;

public class JooqModuleFactory {
    public static final String GENERATE = "generate";
    public static final String JOOQ_CODEGEN = "jooq-codegen";
    public static final String JOOQ_CODEGEN_MAVEN = "jooq-codegen-maven";
    public static final String ORG_JOOQ = "org.jooq";
    public static final String MSSQL_PASSWORD = "yourStrong(!)Password";
    public static final String ORG_POSTGRESQL = "org.postgresql";
    private static final String MYSQL = "mysql";
    private static final String MYSQL_GROUP_ID = "com.mysql";
    private static final String MYSQL_ARTIFACT_ID = "mysql-connector-j";
    private static final String SPRING_DATASOURCE_URL = "spring.datasource.url";
    private static final String SPRING_DATASOURCE_USERNAME = "spring.datasource.username";
    private static final String SPRING_DATASOURCE_DRIVER_CLASS_NAME = "spring.datasource.driver-class-name";
    private final DockerImages dockerImages;

    public JooqModuleFactory(DockerImages dockerImages) {
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildPostgresql(JHipsterModuleProperties properties) {
        DockerImageVersion dockerImage = this.dockerImages.get("postgres");
        return CommonModuleBuilder.commonModuleBuilder(properties, DatabaseType.POSTGRESQL, dockerImage, JHipsterModule.documentationTitle("Postgresql"), JHipsterModule.artifactId("postgresql")).javaDependencies().addDependency(JavaDependency.builder().groupId(JHipsterModule.groupId(ORG_POSTGRESQL)).artifactId(JHipsterModule.artifactId("postgresql")).scope(JavaDependencyScope.RUNTIME).build()).and().mavenPlugins().plugin(JHipsterModule.mavenPlugin().groupId(ORG_JOOQ).artifactId(JOOQ_CODEGEN_MAVEN).versionSlug("jooq").addExecution(JHipsterModule.pluginExecution().goals(GENERATE).id(JOOQ_CODEGEN).phase(MavenBuildPhase.GENERATE_RESOURCES)).configuration(JHipsterModule.jooqModuleCodegenConfiguration().database(tech.jhipster.lite.module.domain.jooqplugin.DatabaseType.POSTGRESQL).databaseUrl("jdbc:postgresql://localhost:5432/" + properties.projectBaseName().name()).user(properties.projectBaseName().name()).inputSchema("public").build().getConfiguration()).build()).and().springMainProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:postgresql://localhost:5432/" + properties.projectBaseName().name())).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_USERNAME), JHipsterModule.propertyValue(properties.projectBaseName().name())).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_DRIVER_CLASS_NAME), JHipsterModule.propertyValue("org.postgresql.Driver")).and().springTestProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:tc:postgresql:" + dockerImage.version().get() + ":///" + properties.projectBaseName().name() + "?TC_TMPFS=/testtmpfs:rw")).and().springMainLogger(ORG_POSTGRESQL, LogLevel.WARN).springTestLogger(ORG_POSTGRESQL, LogLevel.WARN).springTestLogger("org.jboss.logging", LogLevel.WARN).build();
    }

    public JHipsterModule buildMariaDB(JHipsterModuleProperties properties) {
        return CommonModuleBuilder.commonModuleBuilder(properties, DatabaseType.MARIADB, this.dockerImages.get("mariadb"), JHipsterModule.documentationTitle("MariaDB"), JHipsterModule.artifactId("mariadb")).javaDependencies().addDependency(JHipsterModule.javaDependency().groupId("org.mariadb.jdbc").artifactId("mariadb-java-client").scope(JavaDependencyScope.RUNTIME).build()).and().mavenPlugins().plugin(JHipsterModule.mavenPlugin().groupId(ORG_JOOQ).artifactId(JOOQ_CODEGEN_MAVEN).versionSlug("jooq").addExecution(JHipsterModule.pluginExecution().goals(GENERATE).id(JOOQ_CODEGEN).phase(MavenBuildPhase.GENERATE_RESOURCES)).configuration(JHipsterModule.jooqModuleCodegenConfiguration().database(tech.jhipster.lite.module.domain.jooqplugin.DatabaseType.MARIADB).databaseUrl("jdbc:mariadb://localhost:3306/" + properties.projectBaseName().name()).user("root").inputSchema("properties.projectBaseName().name()").build().getConfiguration()).build()).and().springMainProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:mariadb://localhost:3306/" + properties.projectBaseName().name())).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_USERNAME), JHipsterModule.propertyValue("root")).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_DRIVER_CLASS_NAME), JHipsterModule.propertyValue("org.mariadb.jdbc.Driver")).and().build();
    }

    public JHipsterModule buildMySQL(JHipsterModuleProperties properties) {
        return CommonModuleBuilder.commonModuleBuilder(properties, DatabaseType.MYSQL, this.dockerImages.get(MYSQL), JHipsterModule.documentationTitle("MySQL"), JHipsterModule.artifactId(MYSQL)).javaDependencies().addDependency(JHipsterModule.javaDependency().groupId(MYSQL_GROUP_ID).artifactId(MYSQL_ARTIFACT_ID).scope(JavaDependencyScope.RUNTIME).build()).and().mavenPlugins().plugin(JHipsterModule.mavenPlugin().groupId(ORG_JOOQ).artifactId(JOOQ_CODEGEN_MAVEN).versionSlug("jooq").addExecution(JHipsterModule.pluginExecution().goals(GENERATE).id(JOOQ_CODEGEN).phase(MavenBuildPhase.GENERATE_RESOURCES)).configuration(JHipsterModule.jooqModuleCodegenConfiguration().database(tech.jhipster.lite.module.domain.jooqplugin.DatabaseType.MYSQL).databaseUrl("jdbc:mysql://localhost:3306/" + properties.projectBaseName().name()).user("root").inputSchema("properties.projectBaseName().name()").build().getConfiguration()).build()).and().springMainProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:mysql://localhost:3306/" + properties.projectBaseName().name())).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_USERNAME), JHipsterModule.propertyValue("root")).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_DRIVER_CLASS_NAME), JHipsterModule.propertyValue("com.mysql.cj.jdbc.Driver")).and().build();
    }

    public JHipsterModule buildMsSQL(JHipsterModuleProperties properties) {
        DockerImageVersion dockerImage = this.dockerImages.get("mcr.microsoft.com/mssql/server");
        JHipsterSource source = JHipsterModule.from("server/springboot/database/common");
        return ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)CommonModuleBuilder.commonModuleBuilder(properties, DatabaseType.MSSQL, dockerImage, JHipsterModule.documentationTitle("MsSQL"), JHipsterModule.artifactId("mssqlserver")).files().add(source.append("docker").template("container-license-acceptance.txt"), JHipsterModule.to("src/test/resources/container-license-acceptance.txt")).add(source.template("MsSQLTestContainerExtension.java"), JHipsterModule.toSrcTestJava().append(properties.basePackage().path()).append("MsSQLTestContainerExtension.java")).and().javaDependencies().addDependency(JHipsterModule.javaDependency().groupId("com.microsoft.sqlserver").artifactId("mssql-jdbc").scope(JavaDependencyScope.RUNTIME).build()).and().mavenPlugins().plugin(JHipsterModule.mavenPlugin().groupId(ORG_JOOQ).artifactId(JOOQ_CODEGEN_MAVEN).versionSlug("jooq").addExecution(JHipsterModule.pluginExecution().goals(GENERATE).id(JOOQ_CODEGEN).phase(MavenBuildPhase.GENERATE_RESOURCES)).configuration(JHipsterModule.jooqModuleCodegenConfiguration().database(tech.jhipster.lite.module.domain.jooqplugin.DatabaseType.MSSQL).databaseUrl("jdbc:sqlserver://localhost:1433;database=" + properties.projectBaseName().name() + ";trustServerCertificate=true").user("SA").inputSchema("model").password(MSSQL_PASSWORD).getConfiguration()).build()).and().springMainProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:sqlserver://localhost:1433;database=" + properties.projectBaseName().name() + ";trustServerCertificate=true")).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_USERNAME), JHipsterModule.propertyValue("SA")).set(JHipsterModule.propertyKey("spring.datasource.password"), JHipsterModule.propertyValue(MSSQL_PASSWORD)).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_DRIVER_CLASS_NAME), JHipsterModule.propertyValue("com.microsoft.sqlserver.jdbc.SQLServerDriver")).and().springTestProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:tc:sqlserver:///;database=" + properties.projectBaseName().name() + ";trustServerCertificate=true?TC_TMPFS=/testtmpfs:rw")).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_USERNAME), JHipsterModule.propertyValue("SA")).set(JHipsterModule.propertyKey("spring.datasource.password"), JHipsterModule.propertyValue(MSSQL_PASSWORD)).and().mandatoryReplacements().in(JHipsterModule.path("src/test/java").append(properties.basePackage().path()).append("IntegrationTest.java")).add(JHipsterModule.lineBeforeText("import org.springframework.boot.test.context.SpringBootTest;"), "import org.junit.jupiter.api.extension.ExtendWith;")).add(JHipsterModule.lineBeforeText("public @interface"), "@ExtendWith(MsSQLTestContainerExtension.class)")).and()).and().springMainLogger("com.microsoft.sqlserver", LogLevel.WARN).springMainLogger("org.reflections", LogLevel.WARN).build();
    }
}

