/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.jooq.infrastructure.primary;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.lite.generator.server.springboot.database.jooq.application.JooqApplicationService;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleOrganization;
import tech.jhipster.lite.module.domain.resource.JHipsterModulePropertiesDefinition;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.shared.slug.domain.JHLiteFeatureSlug;
import tech.jhipster.lite.shared.slug.domain.JHLiteModuleSlug;

@Configuration
class JooqModuleConfiguration {
    private static final String API_DOC_GROUP = "Spring Boot - Database";

    JooqModuleConfiguration() {
    }

    @Bean
    JHipsterModuleResource jooqPostgresqlModule(JooqApplicationService postgresql) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.JOOQ_POSTGRESQL).propertiesDefinition(JooqModuleConfiguration.properties()).apiDoc(API_DOC_GROUP, "Add Jooq with Postgresql to project").organization(JooqModuleConfiguration.organization()).tags(JooqModuleConfiguration.tags()).factory(postgresql::buildPostgresql);
    }

    @Bean
    JHipsterModuleResource jooqMariaDBModule(JooqApplicationService applicationService) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.JOOQ_MARIADB).propertiesDefinition(JooqModuleConfiguration.properties()).apiDoc(API_DOC_GROUP, "Add Jooq with MariaDB to project").organization(JooqModuleConfiguration.organization()).tags(JooqModuleConfiguration.tags()).factory(applicationService::buildMariaDB);
    }

    @Bean
    JHipsterModuleResource jooqMySQLModule(JooqApplicationService applicationService) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.JOOQ_MYSQL).propertiesDefinition(JooqModuleConfiguration.properties()).apiDoc(API_DOC_GROUP, "Add Jooq with MySQL to project").organization(JooqModuleConfiguration.organization()).tags(JooqModuleConfiguration.tags()).factory(applicationService::buildMySQL);
    }

    @Bean
    JHipsterModuleResource jooqMsSQLModule(JooqApplicationService applicationService) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.JOOQ_MSSQL).propertiesDefinition(JooqModuleConfiguration.properties()).apiDoc(API_DOC_GROUP, "Add Jooq with MsSQL to project").organization(JooqModuleConfiguration.organization()).tags(JooqModuleConfiguration.tags()).factory(applicationService::buildMsSQL);
    }

    private static JHipsterModulePropertiesDefinition properties() {
        return JHipsterModulePropertiesDefinition.builder().addBasePackage().addIndentation().addProjectBaseName().addSpringConfigurationFormat().build();
    }

    private static JHipsterModuleOrganization organization() {
        return JHipsterModuleOrganization.builder().feature(JHLiteFeatureSlug.JOOQ).addDependency(JHLiteModuleSlug.SPRING_BOOT).build();
    }

    private static String[] tags() {
        return new String[]{"server", "spring", "spring-boot", "database"};
    }
}

