/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.database.jpa.domain;

import tech.jhipster.lite.generator.server.springboot.database.jpa.domain.DatabaseType;
import tech.jhipster.lite.generator.server.springboot.database.jpa.domain.SQLCommonModuleBuilder;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.docker.DockerImageVersion;
import tech.jhipster.lite.module.domain.docker.DockerImages;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacementsFactory;

public class JpaModuleFactory {
    public static final String ORG_POSTGRESQL = "org.postgresql";
    private static final String MYSQL = "mysql";
    private static final String MYSQL_GROUP_ID = "com.mysql";
    private static final String MYSQL_ARTIFACT_ID = "mysql-connector-j";
    private static final String SPRING_DATASOURCE_URL = "spring.datasource.url";
    private static final String SPRING_DATASOURCE_USERNAME = "spring.datasource.username";
    private static final String SPRING_DATASOURCE_DRIVER_CLASS_NAME = "spring.datasource.driver-class-name";
    private final DockerImages dockerImages;

    public JpaModuleFactory(DockerImages dockerImages) {
        this.dockerImages = dockerImages;
    }

    public JHipsterModule buildPostgresql(JHipsterModuleProperties properties) {
        DockerImageVersion dockerImage = this.dockerImages.get("postgres");
        return SQLCommonModuleBuilder.sqlCommonModuleBuilder(properties, DatabaseType.POSTGRESQL, dockerImage, JHipsterModule.documentationTitle("Postgresql"), JHipsterModule.artifactId("postgresql")).javaDependencies().addDependency(JavaDependency.builder().groupId(JHipsterModule.groupId(ORG_POSTGRESQL)).artifactId(JHipsterModule.artifactId("postgresql")).scope(JavaDependencyScope.RUNTIME).build()).and().springMainProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:postgresql://localhost:5432/" + properties.projectBaseName().name())).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_USERNAME), JHipsterModule.propertyValue(properties.projectBaseName().name())).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_DRIVER_CLASS_NAME), JHipsterModule.propertyValue("org.postgresql.Driver")).and().springTestProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:tc:postgresql:" + dockerImage.version().get() + ":///" + properties.projectBaseName().name() + "?TC_TMPFS=/testtmpfs:rw")).and().springMainLogger(ORG_POSTGRESQL, LogLevel.WARN).springTestLogger(ORG_POSTGRESQL, LogLevel.WARN).springTestLogger("org.jboss.logging", LogLevel.WARN).build();
    }

    public JHipsterModule buildMariaDB(JHipsterModuleProperties properties) {
        return SQLCommonModuleBuilder.sqlCommonModuleBuilder(properties, DatabaseType.MARIADB, this.dockerImages.get("mariadb"), JHipsterModule.documentationTitle("MariaDB"), JHipsterModule.artifactId("mariadb")).javaDependencies().addDependency(JHipsterModule.javaDependency().groupId("org.mariadb.jdbc").artifactId("mariadb-java-client").scope(JavaDependencyScope.RUNTIME).build()).and().springMainProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:mariadb://localhost:3306/" + properties.projectBaseName().name())).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_USERNAME), JHipsterModule.propertyValue("root")).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_DRIVER_CLASS_NAME), JHipsterModule.propertyValue("org.mariadb.jdbc.Driver")).and().build();
    }

    public JHipsterModule buildMySQL(JHipsterModuleProperties properties) {
        return SQLCommonModuleBuilder.sqlCommonModuleBuilder(properties, DatabaseType.MYSQL, this.dockerImages.get(MYSQL), JHipsterModule.documentationTitle("MySQL"), JHipsterModule.artifactId(MYSQL)).javaDependencies().addDependency(JHipsterModule.javaDependency().groupId(MYSQL_GROUP_ID).artifactId(MYSQL_ARTIFACT_ID).scope(JavaDependencyScope.RUNTIME).build()).and().springMainProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:mysql://localhost:3306/" + properties.projectBaseName().name())).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_USERNAME), JHipsterModule.propertyValue("root")).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_DRIVER_CLASS_NAME), JHipsterModule.propertyValue("com.mysql.cj.jdbc.Driver")).and().build();
    }

    public JHipsterModule buildMsSQL(JHipsterModuleProperties properties) {
        DockerImageVersion dockerImage = this.dockerImages.get("mcr.microsoft.com/mssql/server");
        JHipsterSource source = JHipsterModule.from("server/springboot/database/common");
        return ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)SQLCommonModuleBuilder.sqlCommonModuleBuilder(properties, DatabaseType.MSSQL, dockerImage, JHipsterModule.documentationTitle("MsSQL"), JHipsterModule.artifactId("mssqlserver")).files().add(source.append("docker").template("container-license-acceptance.txt"), JHipsterModule.to("src/test/resources/container-license-acceptance.txt")).add(source.template("MsSQLTestContainerExtension.java"), JHipsterModule.toSrcTestJava().append(properties.basePackage().path()).append("MsSQLTestContainerExtension.java")).and().javaDependencies().addDependency(JHipsterModule.javaDependency().groupId("com.microsoft.sqlserver").artifactId("mssql-jdbc").scope(JavaDependencyScope.RUNTIME).build()).and().springMainProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:sqlserver://localhost:1433;database=" + properties.projectBaseName().name() + ";trustServerCertificate=true")).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_USERNAME), JHipsterModule.propertyValue("SA")).set(JHipsterModule.propertyKey("spring.datasource.password"), JHipsterModule.propertyValue("yourStrong(!)Password")).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_DRIVER_CLASS_NAME), JHipsterModule.propertyValue("com.microsoft.sqlserver.jdbc.SQLServerDriver")).set(JHipsterModule.propertyKey("spring.jpa.hibernate.ddl-auto"), JHipsterModule.propertyValue("update")).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.criteria.literal_handling_mode"), JHipsterModule.propertyValue("BIND")).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.dialect"), JHipsterModule.propertyValue("org.hibernate.dialect.SQLServer2012Dialect")).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.format_sql"), JHipsterModule.propertyValue(true)).set(JHipsterModule.propertyKey("spring.jpa.properties.hibernate.jdbc.fetch_size"), JHipsterModule.propertyValue(150)).and().springTestProperties().set(JHipsterModule.propertyKey(SPRING_DATASOURCE_URL), JHipsterModule.propertyValue("jdbc:tc:sqlserver:///;database=" + properties.projectBaseName().name() + ";trustServerCertificate=true?TC_TMPFS=/testtmpfs:rw")).set(JHipsterModule.propertyKey(SPRING_DATASOURCE_USERNAME), JHipsterModule.propertyValue("SA")).set(JHipsterModule.propertyKey("spring.datasource.password"), JHipsterModule.propertyValue("yourStrong(!)Password")).and().mandatoryReplacements().in(JHipsterModule.path("src/test/java").append(properties.basePackage().path()).append("IntegrationTest.java")).add(JHipsterModule.lineBeforeText("import org.springframework.boot.test.context.SpringBootTest;"), "import org.junit.jupiter.api.extension.ExtendWith;")).add(JHipsterModule.lineBeforeText("public @interface"), "@ExtendWith(MsSQLTestContainerExtension.class)")).and()).and().springMainLogger("com.microsoft.sqlserver", LogLevel.WARN).springMainLogger("org.reflections", LogLevel.WARN).build();
    }
}

