/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.dbmigration.liquibase.infrastructure.primary;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.lite.generator.server.springboot.dbmigration.liquibase.application.LiquibaseApplicationService;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleOrganization;
import tech.jhipster.lite.module.domain.resource.JHipsterModulePropertiesDefinition;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.shared.slug.domain.JHLiteFeatureSlug;
import tech.jhipster.lite.shared.slug.domain.JHLiteModuleSlug;

@Configuration
class LiquibaseModuleConfiguration {
    private static final String SPRING_BOOT_DATABASE_MIGRATION = "Spring Boot - Database Migration";

    LiquibaseModuleConfiguration() {
    }

    @Bean
    JHipsterModuleResource liquibaseModule(LiquibaseApplicationService liquibase) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.LIQUIBASE).propertiesDefinition(JHipsterModulePropertiesDefinition.builder().addIndentation().addSpringConfigurationFormat().build()).apiDoc(SPRING_BOOT_DATABASE_MIGRATION, "Add Liquibase").organization(JHipsterModuleOrganization.builder().feature(JHLiteFeatureSlug.DATABASE_MIGRATION).addDependency(JHLiteFeatureSlug.JPA_PERSISTENCE).addDependency(JHLiteModuleSlug.LOGS_SPY).build()).tags(this.liquibaseTags()).factory(liquibase::buildModule);
    }

    private String[] liquibaseTags() {
        return new String[]{"liquibase", "database", "migration", "spring", "spring-boot"};
    }

    @Bean
    JHipsterModuleResource liquibaseAsyncModule(LiquibaseApplicationService liquibase) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.LIQUIBASE_ASYNC).propertiesDefinition(JHipsterModulePropertiesDefinition.builder().addIndentation().addBasePackage().addSpringConfigurationFormat().build()).apiDoc(SPRING_BOOT_DATABASE_MIGRATION, "Support updating the database asynchronously with Liquibase").organization(JHipsterModuleOrganization.builder().addDependency(JHLiteModuleSlug.LIQUIBASE).build()).tags(this.liquibaseTags()).factory(liquibase::buildAsyncModule);
    }

    @Bean
    JHipsterModuleResource liquibaseLinterModule(LiquibaseApplicationService liquibase) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.LIQUIBASE_LINTER).propertiesDefinition(JHipsterModulePropertiesDefinition.EMPTY).apiDoc(SPRING_BOOT_DATABASE_MIGRATION, "Configure a linter for the Liquibase migration scripts").organization(JHipsterModuleOrganization.builder().addDependency(JHLiteModuleSlug.LIQUIBASE).addDependency(JHLiteModuleSlug.MAVEN_JAVA).build()).tags("server", "database", "migration", "liquibase", "linter").factory(liquibase::buildLinterModule);
    }
}

