/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.mvc.security.oauth2.auth0.infrastructure.primary;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.lite.generator.server.springboot.mvc.security.oauth2.auth0.application.OAuth2Auth0SecurityApplicationService;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleOrganization;
import tech.jhipster.lite.module.domain.resource.JHipsterModulePropertiesDefinition;
import tech.jhipster.lite.module.domain.resource.JHipsterModulePropertyDefinition;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.shared.slug.domain.JHLiteFeatureSlug;
import tech.jhipster.lite.shared.slug.domain.JHLiteModuleSlug;

@Configuration
class OAuth2Auth0ModuleConfiguration {
    private static final String AUTHENTICATION = "authentication";

    OAuth2Auth0ModuleConfiguration() {
    }

    @Bean
    JHipsterModuleResource oAuth2Auth0Module(OAuth2Auth0SecurityApplicationService oAuth2) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.SPRING_BOOT_OAUTH_2_AUTH_0).propertiesDefinition(this.initPropertiesDefinition()).apiDoc("Spring Boot - MVC - Security", "Add a Spring Security: OAuth 2.0 / OIDC Authentication / Auth0 Provider (stateful, works with Keycloak and Auth0)").organization(JHipsterModuleOrganization.builder().feature(JHLiteFeatureSlug.OAUTH_PROVIDER).addDependency(JHLiteModuleSlug.SPRING_BOOT_OAUTH_2).build()).tags("server", "spring", "spring-boot", AUTHENTICATION, "auth0").factory(oAuth2::buildOAuth2Auth0Module);
    }

    private JHipsterModulePropertiesDefinition initPropertiesDefinition() {
        return JHipsterModulePropertiesDefinition.builder().addProjectBaseName().addProjectName().add(OAuth2Auth0ModuleConfiguration.auth0Domain()).add(OAuth2Auth0ModuleConfiguration.auth0clientId()).addIndentation().addSpringConfigurationFormat().build();
    }

    public static JHipsterModulePropertyDefinition auth0Domain() {
        return JHipsterModulePropertyDefinition.mandatoryStringProperty("auth0Domain").description("Auth0 domain").defaultValue("dev-123456.us.auth0.com").order(800).build();
    }

    public static JHipsterModulePropertyDefinition auth0clientId() {
        return JHipsterModulePropertyDefinition.mandatoryStringProperty("auth0ClientId").description("Auth0 Client ID for OIDC application").defaultValue("0oab8eb55Kb9jdMIr5d6").order(900).build();
    }
}

