/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.springboot.webflux.web.domain;

import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javadependency.JavaDependency;
import tech.jhipster.lite.module.domain.javadependency.JavaDependencyScope;
import tech.jhipster.lite.module.domain.javaproperties.PropertyKey;
import tech.jhipster.lite.module.domain.properties.JHipsterModuleProperties;
import tech.jhipster.lite.shared.error.domain.Assert;

public class SpringBootWebfluxModuleFactory {
    private static final JHipsterSource SOURCE = JHipsterModule.from("server/springboot/webflux/web");
    private static final JHipsterSource JACKSON_MAIN_SOURCE = JHipsterModule.from("server/springboot/jackson/main");
    private static final JHipsterSource JACKSON_TEST_SOURCE = JHipsterModule.from("server/springboot/jackson/test");
    private static final String WIRE_JACKSON_CONFIG = "wire/jackson/infrastructure/primary";
    private static final PropertyKey SERVER_PORT = JHipsterModule.propertyKey("server.port");
    private static final GroupId SPRING_GROUP = JHipsterModule.groupId("org.springframework.boot");
    private static final String EXCEPTION_PRIMARY = "shared/error/infrastructure/primary";

    public JHipsterModule buildEmptyModule(JHipsterModuleProperties properties) {
        return JHipsterModule.moduleBuilder(properties).build();
    }

    public JHipsterModule buildNettyModule(JHipsterModuleProperties properties) {
        Assert.notNull("properties", properties);
        String packagePath = properties.packagePath();
        return JHipsterModule.moduleBuilder(properties).javaDependencies().addDependency(SPRING_GROUP, JHipsterModule.artifactId("spring-boot-starter-webflux")).addDependency(this.reactorTestDependency()).addDependency(SPRING_GROUP, JHipsterModule.artifactId("spring-boot-starter-validation")).and().springMainProperties().set(SERVER_PORT, JHipsterModule.propertyValue(properties.serverPort().get())).set(JHipsterModule.propertyKey("spring.jackson.default-property-inclusion"), JHipsterModule.propertyValue("non_absent")).and().springTestProperties().set(SERVER_PORT, JHipsterModule.propertyValue(0)).and().files().add(JACKSON_MAIN_SOURCE.append(WIRE_JACKSON_CONFIG).template("JacksonConfiguration.java"), JHipsterModule.toSrcMainJava().append(packagePath).append(WIRE_JACKSON_CONFIG).append("JacksonConfiguration.java")).add(JACKSON_TEST_SOURCE.append(WIRE_JACKSON_CONFIG).template("JacksonConfigurationIT.java"), JHipsterModule.toSrcTestJava().append(packagePath).append(WIRE_JACKSON_CONFIG).append("JacksonConfigurationIT.java")).batch(SOURCE.append("main"), JHipsterModule.toSrcMainJava().append(packagePath).append(EXCEPTION_PRIMARY)).addTemplate("FieldErrorDTO.java").addTemplate("HeaderUtil.java").and().batch(SOURCE.append("test"), JHipsterModule.toSrcTestJava().append(packagePath).append(EXCEPTION_PRIMARY)).addTemplate("HeaderUtilTest.java").addTemplate("FieldErrorDTOTest.java").and().add(SOURCE.template("test/TestUtil.java"), JHipsterModule.toSrcTestJava().append(packagePath).append("TestUtil.java")).and().build();
    }

    private JavaDependency reactorTestDependency() {
        return JHipsterModule.javaDependency().groupId("io.projectreactor").artifactId("reactor-test").scope(JavaDependencyScope.TEST).build();
    }
}

