/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.generator.server.webjars.infrastructure.primary;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import tech.jhipster.lite.generator.server.webjars.application.WebjarsApplicationService;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleOrganization;
import tech.jhipster.lite.module.domain.resource.JHipsterModulePropertiesDefinition;
import tech.jhipster.lite.module.domain.resource.JHipsterModuleResource;
import tech.jhipster.lite.shared.slug.domain.JHLiteModuleSlug;

@Configuration
class WebjarsModuleConfiguration {
    private static final String SERVER_TAG = "server";
    private static final String WEB_TAG = "web";
    private static final String WEBJARS_GROUP = "WebJars";

    WebjarsModuleConfiguration() {
    }

    @Bean
    public JHipsterModuleResource webjarsLocatorModule(WebjarsApplicationService webjarsModule) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.WEBJARS_LOCATOR).propertiesDefinition(JHipsterModulePropertiesDefinition.builder().addBasePackage().addProjectBaseName().addSpringConfigurationFormat().build()).apiDoc(WEBJARS_GROUP, "Add webjars locator to the project").organization(JHipsterModuleOrganization.builder().addDependency(JHLiteModuleSlug.SPRING_BOOT_THYMELEAF).build()).tags(SERVER_TAG, WEB_TAG).factory(webjarsModule::buildWebjarsLocatorModule);
    }

    @Bean
    public JHipsterModuleResource webjarsHtmxModule(WebjarsApplicationService webjarsModule) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.HTMX_WEBJARS).propertiesDefinition(JHipsterModulePropertiesDefinition.builder().addBasePackage().addProjectBaseName().addSpringConfigurationFormat().build()).apiDoc(WEBJARS_GROUP, "Add HTMX webjar to the project").organization(JHipsterModuleOrganization.builder().addDependency(JHLiteModuleSlug.WEBJARS_LOCATOR).build()).tags(SERVER_TAG, WEB_TAG).factory(webjarsModule::buildWebjarsHtmxModule);
    }

    @Bean
    public JHipsterModuleResource webjarsAlpineJSModule(WebjarsApplicationService webjarsModule) {
        return JHipsterModuleResource.builder().slug(JHLiteModuleSlug.ALPINE_JS_WEBJARS).propertiesDefinition(JHipsterModulePropertiesDefinition.builder().addBasePackage().addProjectBaseName().addSpringConfigurationFormat().build()).apiDoc(WEBJARS_GROUP, "Add alpine.js webjar to the project").organization(JHipsterModuleOrganization.builder().addDependency(JHLiteModuleSlug.WEBJARS_LOCATOR).build()).tags(SERVER_TAG, WEB_TAG).factory(webjarsModule::buildWebjarsAlpineJSModule);
    }
}

