/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain;

import java.util.regex.Pattern;
import tech.jhipster.lite.module.domain.DocumentationTitle;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.JHipsterProjectFilePath;
import tech.jhipster.lite.module.domain.LocalEnvironment;
import tech.jhipster.lite.module.domain.LogLevel;
import tech.jhipster.lite.module.domain.PreCommitCommands;
import tech.jhipster.lite.module.domain.StagedFilesFilter;
import tech.jhipster.lite.module.domain.file.JHipsterSource;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleMandatoryReplacementsFactory;
import tech.jhipster.lite.module.domain.replacement.JHipsterModuleOptionalReplacementsFactory;
import tech.jhipster.lite.module.domain.replacement.OptionalReplacer;
import tech.jhipster.lite.module.domain.replacement.ReplacementCondition;
import tech.jhipster.lite.module.domain.replacement.TextNeedleAfterReplacer;
import tech.jhipster.lite.module.domain.replacement.TextNeedleBeforeReplacer;
import tech.jhipster.lite.shared.error.domain.Assert;

final class JHipsterModuleShortcuts {
    private static final JHipsterProjectFilePath README = JHipsterModule.path("README.md");
    private static final TextNeedleBeforeReplacer JHIPSTER_DOCUMENTATION_NEEDLE = JHipsterModule.lineBeforeText("\n<!-- jhipster-needle-documentation -->");
    private static final TextNeedleBeforeReplacer JHIPSTER_LOCAL_ENVIRONMENT_NEEDLE = JHipsterModule.lineBeforeText("\n<!-- jhipster-needle-localEnvironment -->");
    private static final TextNeedleAfterReplacer JHIPSTER_PREREQUISITES = JHipsterModule.lineAfterText("\n## Prerequisites");
    private static final JHipsterProjectFilePath SPRING_MAIN_LOG_FILE = JHipsterModule.path("src/main/resources/logback-spring.xml");
    private static final JHipsterProjectFilePath SPRING_TEST_LOG_FILE = JHipsterModule.path("src/test/resources/logback.xml");
    private static final TextNeedleBeforeReplacer JHIPSTER_LOGGER_NEEDLE = JHipsterModule.lineBeforeText("<!-- jhipster-needle-logback-add-log -->");
    private static final Pattern DEFAULT_LINTSTAGED_CONFIGURATION_ENTRY = Pattern.compile("\\s*'\\*': \\[\\s*].*");
    private final JHipsterModule.JHipsterModuleBuilder builder;

    JHipsterModuleShortcuts(JHipsterModule.JHipsterModuleBuilder builder) {
        Assert.notNull("builder", builder);
        this.builder = builder;
    }

    void documentation(DocumentationTitle title, JHipsterSource source) {
        Assert.notNull("title", title);
        Assert.notNull("source", source);
        String target = "documentation/" + title.filename() + source.extension();
        this.builder.files().add(source, JHipsterModule.to(target));
        String markdownLink = "- [" + title.get() + "](" + target + ")";
        this.builder.optionalReplacements().in(README).add(JHIPSTER_DOCUMENTATION_NEEDLE, markdownLink);
    }

    void localEnvironment(LocalEnvironment localEnvironment) {
        Assert.notNull("localEnvironment", localEnvironment);
        this.builder.optionalReplacements().in(README).add(JHIPSTER_LOCAL_ENVIRONMENT_NEEDLE, localEnvironment.get());
    }

    void prerequisites(String prerequisites) {
        Assert.notBlank("prerequisites", prerequisites);
        this.builder.optionalReplacements().in(README).add(JHIPSTER_PREREQUISITES, prerequisites);
    }

    void springTestLogger(String name, LogLevel level) {
        Assert.notBlank("name", name);
        Assert.notNull("level", (Object)level);
        this.builder.optionalReplacements().in(SPRING_TEST_LOG_FILE).add(this.logConfigurationEntry(name, level));
    }

    void springMainLogger(String name, LogLevel level) {
        Assert.notBlank("name", name);
        Assert.notNull("level", (Object)level);
        this.builder.optionalReplacements().in(SPRING_MAIN_LOG_FILE).add(this.logConfigurationEntry(name, level));
    }

    private OptionalReplacer logConfigurationEntry(String name, LogLevel level) {
        return new OptionalReplacer(JHIPSTER_LOGGER_NEEDLE, this.logger(name, level));
    }

    private String logger(String name, LogLevel level) {
        return this.builder.indentation().spaces() + "<logger name=\"" + name + "\" level=\"" + level.value() + "\" />";
    }

    public void integrationTestExtension(String extensionClass) {
        Assert.notBlank("extensionClass", extensionClass);
        ((JHipsterModuleMandatoryReplacementsFactory.JHipsterModuleFileMandatoryReplacementsFactoryBuilder)this.builder.mandatoryReplacements().in(JHipsterModule.path("src/test/java").append(this.builder.packagePath()).append("IntegrationTest.java")).add(JHipsterModule.lineBeforeText("import org.springframework.boot.test.context.SpringBootTest;"), "import org.junit.jupiter.api.extension.ExtendWith;")).add(JHipsterModule.lineBeforeText("public @interface"), "@ExtendWith(" + extensionClass + ".class)");
    }

    public void preCommitActions(StagedFilesFilter stagedFilesFilter, PreCommitCommands preCommitCommands) {
        Assert.notNull("stagedFilesFilter", stagedFilesFilter);
        Assert.notNull("preCommitCommands", preCommitCommands);
        String newLintStagedConfigurationEntry = "%s'%s': %s,".formatted(this.builder.properties().indentation().times(1), stagedFilesFilter, preCommitCommands);
        ((JHipsterModuleOptionalReplacementsFactory.JHipsterModuleFileOptionalReplacementsFactoryBuilder)this.builder.optionalReplacements().in(JHipsterModule.path(".lintstagedrc.cjs")).add(JHipsterModule.regex(ReplacementCondition.always(), DEFAULT_LINTSTAGED_CONFIGURATION_ENTRY), "")).add(JHipsterModule.lineAfterRegex("module.exports = \\{"), newLintStagedConfigurationEntry);
    }
}

