/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import tech.jhipster.lite.shared.error.domain.Assert;

public record PreCommitCommands(String commands) {
    public PreCommitCommands {
        Assert.notBlank("commands", commands);
    }

    public static PreCommitCommands of(String ... commands) {
        Assert.notEmpty("commands", commands);
        if (commands.length == 1) {
            String command = commands[0];
            if (command.matches("^\\[.*]$")) {
                return new PreCommitCommands(command);
            }
            return new PreCommitCommands(PreCommitCommands.withQuotes(command));
        }
        return new PreCommitCommands(Stream.of(commands).map(PreCommitCommands::withQuotes).collect(Collectors.joining(", ", "[", "]")));
    }

    private static String withQuotes(String command) {
        if (command.matches("^'.*'$")) {
            return command;
        }
        return "'%s'".formatted(command);
    }

    public String get() {
        return this.commands;
    }

    @Override
    public String toString() {
        return this.commands;
    }
}

