/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.gitignore;

import tech.jhipster.lite.shared.error.domain.Assert;

public sealed interface GitIgnoreEntry {
    public String get();

    public record GitIgnoreComment(String value) implements GitIgnoreEntry
    {
        private static final String COMMENT_PREFIX = "#";

        public GitIgnoreComment(String value) {
            Assert.notBlank("value", value);
            this.value = value.startsWith(COMMENT_PREFIX) ? value : "# " + value;
        }

        @Override
        public String get() {
            return this.value;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }

    public record GitIgnorePattern(String value) implements GitIgnoreEntry
    {
        public GitIgnorePattern {
            Assert.notBlank("value", value);
        }

        @Override
        public String get() {
            return this.value;
        }

        @Override
        public String toString() {
            return this.value;
        }
    }
}

