/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.javabuild;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import tech.jhipster.lite.module.domain.JHipsterModule;
import tech.jhipster.lite.module.domain.javabuild.ArtifactId;
import tech.jhipster.lite.module.domain.javabuild.GroupId;
import tech.jhipster.lite.module.domain.javabuild.MavenBuildExtension;
import tech.jhipster.lite.module.domain.javabuild.VersionSlug;
import tech.jhipster.lite.module.domain.javabuild.command.AddMavenBuildExtension;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommand;
import tech.jhipster.lite.module.domain.javabuild.command.JavaBuildCommands;
import tech.jhipster.lite.module.domain.javabuild.command.SetVersion;
import tech.jhipster.lite.module.domain.javadependency.JavaDependenciesVersions;
import tech.jhipster.lite.shared.error.domain.Assert;

public class JHipsterModuleMavenBuildExtensions {
    private final Collection<MavenBuildExtension> buildExtensions;

    public JHipsterModuleMavenBuildExtensions(JHipsterModuleMavenBuildExtensionsBuilder builder) {
        this.buildExtensions = builder.buildExtensions;
    }

    public JavaBuildCommands buildChanges(JavaDependenciesVersions versions) {
        Assert.notNull("versions", versions);
        List<JavaBuildCommand> addBuildExtensions = this.buildExtensions.stream().flatMap(JHipsterModuleMavenBuildExtensions.toCommands(versions, AddMavenBuildExtension::new)).toList();
        return new JavaBuildCommands(addBuildExtensions);
    }

    private static Function<MavenBuildExtension, Stream<JavaBuildCommand>> toCommands(JavaDependenciesVersions versions, Function<MavenBuildExtension, JavaBuildCommand> addCommandFactory) {
        return extension -> {
            JavaBuildCommand addBuildExtensionCommand = (JavaBuildCommand)addCommandFactory.apply((MavenBuildExtension)extension);
            return extension.versionSlug().map(version -> Stream.of(new SetVersion(versions.get((VersionSlug)version)), addBuildExtensionCommand)).orElseGet(() -> Stream.of(addBuildExtensionCommand));
        };
    }

    public static JHipsterModuleMavenBuildExtensionsBuilder builder(JHipsterModule.JHipsterModuleBuilder module) {
        return new JHipsterModuleMavenBuildExtensionsBuilder(module);
    }

    public static final class JHipsterModuleMavenBuildExtensionsBuilder {
        private final JHipsterModule.JHipsterModuleBuilder module;
        private final Collection<MavenBuildExtension> buildExtensions = new ArrayList<MavenBuildExtension>();

        private JHipsterModuleMavenBuildExtensionsBuilder(JHipsterModule.JHipsterModuleBuilder module) {
            Assert.notNull("module", module);
            this.module = module;
        }

        public JHipsterModuleMavenBuildExtensionsBuilder addExtension(MavenBuildExtension buildExtension) {
            Assert.notNull("buildExtension", buildExtension);
            this.buildExtensions.add(buildExtension);
            return this;
        }

        public JHipsterModuleMavenBuildExtensionsBuilder addExtension(GroupId groupId, ArtifactId artifactId, VersionSlug versionSlug) {
            MavenBuildExtension buildExtension = MavenBuildExtension.builder().groupId(groupId).artifactId(artifactId).versionSlug(versionSlug).build();
            return this.addExtension(buildExtension);
        }

        public JHipsterModule.JHipsterModuleBuilder and() {
            return this.module;
        }

        public JHipsterModuleMavenBuildExtensions build() {
            return new JHipsterModuleMavenBuildExtensions(this);
        }
    }
}

