/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.javaproperties;

import tech.jhipster.lite.module.domain.javaproperties.Comment;
import tech.jhipster.lite.module.domain.javaproperties.PropertyKey;
import tech.jhipster.lite.module.domain.javaproperties.SpringProfile;
import tech.jhipster.lite.module.domain.javaproperties.SpringPropertyType;
import tech.jhipster.lite.module.domain.javaproperties.SpringPropertyTypeFileName;
import tech.jhipster.lite.shared.error.domain.Assert;

public final class SpringComment
implements SpringPropertyTypeFileName {
    private final SpringPropertyType type;
    private final PropertyKey key;
    private final Comment comment;
    private final SpringProfile profile;

    private SpringComment(SpringCommentBuilder builder) {
        Assert.notNull("key", builder.key);
        Assert.notNull("comment", builder.comment);
        this.type = builder.type;
        this.key = builder.key;
        this.comment = builder.comment;
        this.profile = this.buildProfile(builder.profile);
    }

    private SpringProfile buildProfile(SpringProfile profile) {
        if (profile == null) {
            return SpringProfile.DEFAULT;
        }
        return profile;
    }

    public static SpringCommentPropertyKeyBuilder builder(SpringPropertyType type) {
        return new SpringCommentBuilder(type);
    }

    @Override
    public SpringPropertyType type() {
        return this.type;
    }

    public PropertyKey key() {
        return this.key;
    }

    public Comment value() {
        return this.comment;
    }

    @Override
    public String filename() {
        if (this.profile.isDefault()) {
            return this.type.filePrefix();
        }
        return this.type.filePrefix() + "-" + this.profile.get();
    }

    private static final class SpringCommentBuilder
    implements SpringCommentPropertyKeyBuilder,
    SpringCommentCommentBuilder,
    SpringCommentProfileBuilder {
        private final SpringPropertyType type;
        private PropertyKey key;
        private Comment comment;
        private SpringProfile profile;

        private SpringCommentBuilder(SpringPropertyType type) {
            Assert.notNull("type", (Object)type);
            this.type = type;
        }

        @Override
        public SpringCommentCommentBuilder key(PropertyKey key) {
            this.key = key;
            return this;
        }

        @Override
        public SpringCommentProfileBuilder comment(Comment comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public SpringCommentProfileBuilder profile(SpringProfile profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public SpringComment build() {
            return new SpringComment(this);
        }
    }

    public static interface SpringCommentProfileBuilder {
        public SpringCommentProfileBuilder profile(SpringProfile var1);

        public SpringComment build();
    }

    public static interface SpringCommentCommentBuilder {
        public SpringCommentProfileBuilder comment(Comment var1);
    }

    public static interface SpringCommentPropertyKeyBuilder {
        public SpringCommentCommentBuilder key(PropertyKey var1);
    }
}

