/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.jooqplugin;

import tech.jhipster.lite.module.domain.jooqplugin.DatabaseType;
import tech.jhipster.lite.shared.error.domain.Assert;

public final class JooqModuleCodegenConfiguration {
    private final DatabaseType database;
    private final String databaseUrl;
    private final String user;
    private final String inputSchema;
    private final String password;

    private JooqModuleCodegenConfiguration(JooqModuleCodegenConfigurationBuilder builder) {
        Assert.notNull("database", (Object)builder.database);
        Assert.notNull("databaseUrl", builder.databaseUrl);
        Assert.notNull("user", builder.user);
        Assert.notNull("inputSchema", builder.inputSchema);
        this.database = builder.database;
        this.databaseUrl = builder.databaseUrl;
        this.user = builder.user;
        this.inputSchema = builder.inputSchema;
        this.password = builder.password == null ? "" : builder.password;
    }

    public String getConfiguration() {
        return String.format("<jdbc>\n  <url>%s</url>\n  <user>%s</user>\n  <password>%s</password>\n</jdbc>\n<generator>\n  <database>\n    <name>%s</name>\n    <includes>.*</includes>\n    <inputSchema>%s</inputSchema>\n  </database>\n  <target>\n    <packageName>org.jooq.codegen</packageName>\n    <directory>target/generated-sources/jooq</directory>\n  </target>\n</generator>\n", this.databaseUrl, this.user, this.password, this.databaseJooqName(), this.inputSchema);
    }

    private String databaseJooqName() {
        return switch (this.database) {
            default -> throw new MatchException(null, null);
            case DatabaseType.POSTGRESQL -> "org.jooq.meta.postgres.PostgresDatabase";
            case DatabaseType.MYSQL -> "org.jooq.meta.mysql.MySQLDatabase";
            case DatabaseType.MARIADB -> "org.jooq.meta.mariadb.MariaDBDatabase";
            case DatabaseType.MSSQL -> "org.jooq.meta.sqlserver.SQLServerDatabase";
        };
    }

    public static JooqModuleCodegenConfigurationBuilder builder() {
        return new JooqModuleCodegenConfigurationBuilder();
    }

    public static final class JooqModuleCodegenConfigurationBuilder
    implements JooqModuleCodegenConfigurationDatabaseBuilder,
    JooqModuleCodegenConfigurationDatabaseUrlBuilder,
    JooqModuleCodegenConfigurationUserBuilder,
    JooqModuleCodegenConfigurationInputSchemaBuilder,
    JooqModuleCodegenConfigurationPasswordBuilder {
        private DatabaseType database;
        private String databaseUrl;
        private String user;
        private String inputSchema;
        private String password;

        @Override
        public JooqModuleCodegenConfigurationDatabaseUrlBuilder database(DatabaseType database) {
            this.database = database;
            return this;
        }

        @Override
        public JooqModuleCodegenConfigurationUserBuilder databaseUrl(String databaseUrl) {
            this.databaseUrl = databaseUrl;
            return this;
        }

        @Override
        public JooqModuleCodegenConfigurationInputSchemaBuilder user(String user) {
            this.user = user;
            return this;
        }

        @Override
        public JooqModuleCodegenConfigurationBuilder inputSchema(String inputSchema) {
            this.inputSchema = inputSchema;
            return this;
        }

        @Override
        public JooqModuleCodegenConfiguration password(String password) {
            this.password = password;
            return this.build();
        }

        public JooqModuleCodegenConfiguration build() {
            return new JooqModuleCodegenConfiguration(this);
        }
    }

    public static interface JooqModuleCodegenConfigurationPasswordBuilder {
        public JooqModuleCodegenConfiguration password(String var1);
    }

    public static interface JooqModuleCodegenConfigurationInputSchemaBuilder {
        public JooqModuleCodegenConfigurationBuilder inputSchema(String var1);
    }

    public static interface JooqModuleCodegenConfigurationUserBuilder {
        public JooqModuleCodegenConfigurationInputSchemaBuilder user(String var1);
    }

    public static interface JooqModuleCodegenConfigurationDatabaseUrlBuilder {
        public JooqModuleCodegenConfigurationUserBuilder databaseUrl(String var1);
    }

    public static interface JooqModuleCodegenConfigurationDatabaseBuilder {
        public JooqModuleCodegenConfigurationDatabaseUrlBuilder database(DatabaseType var1);
    }
}

