/*
 * Decompiled with CFR 0.152.
 */
package tech.jhipster.lite.module.domain.replacement;

import java.util.function.BiFunction;
import java.util.regex.Pattern;
import tech.jhipster.lite.module.domain.replacement.ElementReplacer;
import tech.jhipster.lite.module.domain.replacement.ReplacementCondition;
import tech.jhipster.lite.shared.error.domain.Assert;
import tech.jhipster.lite.shared.generation.domain.ExcludeFromGeneratedCodeCoverage;

public record EndOfFileReplacer(ReplacementCondition condition) implements ElementReplacer
{
    private static final Pattern EOF_PATTERN = Pattern.compile("\\z", 8);

    public EndOfFileReplacer {
        Assert.notNull("condition", condition);
        Assert.notNull("pattern", EOF_PATTERN);
    }

    @Override
    @ExcludeFromGeneratedCodeCoverage(reason="Pattern always matches")
    public boolean notMatchIn(String content) {
        return !EOF_PATTERN.matcher(content).find();
    }

    @Override
    public BiFunction<String, String, String> replacement() {
        return (content, replacement) -> EOF_PATTERN.matcher((CharSequence)content).replaceAll(result -> this.escapeSpecialCharacters((String)replacement) + "\n" + result.group());
    }

    private String escapeSpecialCharacters(String replacement) {
        return replacement.replace("$", "\\$");
    }

    @Override
    public String searchMatcher() {
        return EOF_PATTERN.pattern();
    }
}

